#!/usr/bin/python
# coding: utf-8

from __future__ import unicode_literals
import argparse
import unicodecsv as csv
import io
import json
from pprint import pprint

def flattenjson(b, delim):
    val = {}
    for i in b.keys():
        if isinstance(b[i], dict):
            get = flattenjson(b[i], delim)
            for j in get.keys():
                val[i + delim + j] = get[j]
        else:
            val[i] = b[i]
    return val


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--input', '-i')
    parser.add_argument('--output', '-o')
    args = parser.parse_args()
    with open(args.input, 'r') as fp:
        indata = json.load(fp, encoding='utf-8')
    indata = map(lambda x: flattenjson(x, '__'), indata)

    columns = map(lambda x: x.keys(), indata)
    columns = reduce(lambda x, y: x + y, columns)
    columns = list(set(columns))

    # pprint(indata)

    # for col in columns:
    #     print indata[100].get(col, '')

    with open(args.output, 'w') as outfile:
        csv_w = csv.writer(outfile, encoding='utf8')
        csv_w.writerow(columns)
        for i_r in indata:
            i_r = {x:i_r[x].decode('utf8') if isinstance(i_r[x], str) else i_r[x] for x in i_r}
            csv_w.writerow(map(lambda x: i_r.get(x, ''), columns))
