#!/usr/bin/env python
#! -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import arrow
import logging
import requests
import datetime
import os
import json
import codecs
import argparse
import subprocess

HEADERS = {'StatRobotUser': 'robot_pecheny',
           'StatRobotPassword': 'OoGh1Adahy'}
logger = None

# https://stat.yandex-team.ru/Distribution/Others/AtomBanners/v2?fields=shows&scale=i&date_max=2015-12-14&date_min=2015-12-11&type=json


def get_stat_data():
    now = arrow.now()
    then = now.replace(days=-3)
    skeleton = 'https://stat.yandex-team.ru/Distribution/Others/AtomBanners/v2?fields=shows&scale=i&date_min={}&date_max={}&_type=json&_raw_data=1'
    skeleton_full = skeleton.format(then.format(
        'YYYY-MM-DD'), now.format('YYYY-MM-DD'))
    req = requests.get(skeleton_full, headers=HEADERS)
    parsed = json.loads(req.content)['values']
    dates = sorted([arrow.get(x['fielddate'] + '+03:00') for x in parsed])
    holes = []
    for e, date in enumerate(dates):
        if e > 0 and (date - dates[e - 1]) > datetime.timedelta(minutes=30):
            mover = dates[e - 1] + datetime.timedelta(minutes=30)
            while mover < date:
                holes.append(mover)
                mover += datetime.timedelta(minutes=30)
    return holes


def main():
    global logger
    parser = argparse.ArgumentParser()
    parser.add_argument('--debug', action='store_true')
    args = parser.parse_args()
    start = arrow.now()

    logger = logging.getLogger('checker')
    formatter = logging.Formatter('%(asctime)s | %(message)s')
    ch = logging.StreamHandler()
    logger.setLevel(logging.DEBUG)
    if args.debug:
        ch.setLevel(logging.DEBUG)
    else:
        ch.setLevel(logging.CRITICAL)
    ch.setFormatter(formatter)
    logger.addHandler(ch)
    if not os.path.isdir('logs'):
        os.mkdir('logs')
    fh = logging.FileHandler('{}/logs/{}_{}.log'.format(
        os.path.dirname(os.path.abspath(__file__)),
        os.path.basename(__file__)[:-3], start.format('YYYY-MM-DD_HH-MM')),
        encoding='utf8')
    fh.setLevel(logging.DEBUG)
    fh.setFormatter(formatter)
    logger.addHandler(fh)

    os.chdir('/home/pecheny')
    holes = get_stat_data()
    for hole in holes:
        if args.debug:
            logger.info(hole.format('YYYY-MM-DD HH-mm-ss'))
        logger.info(subprocess.check_output('python /home/pecheny/new/distribution/ffastlogs_installs_monitoring.py {}--datetimefrom {} --datetimeto {}'
                                            .format(('--debug ' if args.debug else ''),
                                                    hole.replace(
                                                        minutes=-1).format('YYYYMMDDHHmm'),
                                                    hole.replace(
                                                        minutes=+1).format('YYYYMMDDHHmm'),
                                                    ), shell=True, stderr=subprocess.STDOUT))
        logger.info(subprocess.check_output('python /home/pecheny/new/distribution/fastlogs_stat_uploader.py {}--datetimefrom {} --datetimeto {}'
                                            .format(('--debug ' if args.debug else ''),
                                                    hole.replace(
                                                        minutes=-1).format('YYYYMMDDHHmm'),
                                                    hole.replace(
                                                        minutes=+1).format('YYYYMMDDHHmm'),
                                                    ), shell=True, stderr=subprocess.STDOUT))


if __name__ == "__main__":
    main()
