#!/usr/bin/env python
#! -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import arrow
import os
import json
import toml
import codecs
import requests
import argparse
import datetime as dt
import smtplib
import pdb
import logging
from collections import Counter
from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email.MIMEText import MIMEText
from email.Utils import COMMASPACE, formatdate
from email import Encoders
from pecheny.moncommons import push_to_razladki
from datetime import datetime as dtdt

_file_ = None


def send_mail(send_from, send_to, subject, text, files=[], server="localhost"):
    assert isinstance(send_to, list)
    assert isinstance(files, list)

    msg = MIMEMultipart()
    msg['From'] = send_from
    msg['To'] = COMMASPACE.join(send_to)
    msg['Date'] = formatdate(localtime=True)
    msg['Subject'] = subject

    msg.attach(MIMEText(text.encode('utf8')))

    for f in files:
        part = MIMEBase('application', "octet-stream")
        part.set_payload(open(f, "rb").read())
        Encoders.encode_base64(part)
        part.add_header('Content-Disposition',
                        'attachment; filename="%s"' % os.path.basename(f))
        msg.attach(part)

    smtp = smtplib.SMTP(server)
    smtp.sendmail(send_from, send_to, msg.as_string())
    smtp.close()

ALLKEYS = [
    "distr_wizard_ru",
    # "distr_wizard_products_ru",
    # "distr_wizard_products_tr",
    "distr_wizard_tr",
    # "_distr_wizard_ru",
    # "_distr_wizard_old_ru",
    # "news",
    "service_block_ru",
    "smart_banner_ru",
    "smart_banner_test_ru",
    "banana/1127_filtered",
    "banana/1141",
    # "_distr_wizard_old_tmp_ru",
    # "mobile_apps_ru",
    # "distr_wizard_yabro_ru",
    # "banana/1127_filtered_noname",
    "banana/promofooter",
    "banana/promofooter_mobile",
    "banana/extensions_popup"
    # "smart_banner_yabro_ru"
]

ALLHOSTS = [
    'default_search',
    'distr_stripe',
    'promofooter',
    'promofooter_mobile',
    'smart-banner',
    # 'daas',
    'extp_popup'
]

EVENTS = {'error', 'show', 'install',
          'close', 'click', 'close_stripe', 'cancel', 'showlanding', 'download'}


def valparse(value):
    values = value.split()
    return {v.split('=')[0]: '='.join(v.split('=')[1:])
            for v in values}


def safediv(x, y):
    try:
        return x / y
    except ZeroDivisionError:
        return 0


def main():

    start = dtdt.now()
    ts = int((start - dtdt(1970, 1, 1)).total_seconds())
    global _file_
    global __file__                         # to fix stupid
    __file__ = os.path.abspath(__file__)    # __file__ handling
    _file_ = os.path.basename(__file__)     # in python 2
    os.chdir(os.path.dirname(__file__))
    params = toml.loads(open('distribution.toml').read())

    parser = argparse.ArgumentParser()
    parser.add_argument('--debug', action='store_true')
    parser.add_argument('--stats', action='store_true')
    args = parser.parse_args()

    logger = logging.getLogger(_file_[:-3])
    formatter = logging.Formatter('%(asctime)s | %(message)s')
    ch = logging.StreamHandler()
    logger.setLevel(logging.DEBUG)
    if args.debug:
        ch.setLevel(logging.DEBUG)
    else:
        ch.setLevel(logging.CRITICAL)
    ch.setFormatter(formatter)
    logger.addHandler(ch)
    fh = logging.FileHandler('{}/logs/{}-{}.log'.format(
        os.path.dirname(__file__), _file_[:-3], start),
        encoding='utf8')
    fh.setLevel(logging.DEBUG)
    fh.setFormatter(formatter)
    logger.addHandler(fh)

    MOZHNO = False
    if os.path.isfile('candidates_data.json'):
        candidates_data = json.loads(open('candidates_data.json').read())
        logger.info('candidates_data.json found')
        MOZHNO = True
    else:
        candidates_data = {}
    if os.path.isfile('hosts_data.json'):
        hosts_data = json.loads(open('hosts_data.json').read())
        logger.info('hosts_data.json found')
    else:
        hosts_data = {}

    for key in ALLHOSTS:
        req = None
        while (((req is None)
                or (req.status_code != 200))
               and ((dtdt.now() - start).total_seconds() < 3600)):
            logger.info('checking {}'.format(key))
            req = requests.get(
                'http://rtmr-sas-000.search.yandex.net:8080/yandsearch?view=json&table=atom/host_scores&key={}&maxrecords=1'.format(key))
            ts = arrow.now().to('Europe/Moscow').timestamp
            # ts = int((dtdt.now() - dtdt(1970, 1, 1)).total_seconds())
            # if args.debug:
            # pdb.set_trace()
        try:
            atomjson = json.loads(req.content)['Entries'][0]['Value']
            # ts = (9223372036854775807 -
            #     int(json.loads(req.content)['Entries'][0]['SubKey']))
        except:
            if args.debug:
                pdb.set_trace()
            logger.error('Error while parsing json: {}'.format(
                req.content.decode('utf8', errors='replace')))
            continue

        counter = Counter()
        if atomjson and len(atomjson) > 0:
            candidate = sorted(atomjson, key=len)[0]
            valdict = valparse(atomjson)
            for event in valdict:
                if event in EVENTS:
                    counter[event] += int(valdict[event])
                else:
                    counter['unknown'] += int(valdict[event])
        else:
            logger.error('{} is null'.format(key))
            continue

        diffdict = Counter()
        last_checked = 1450096880
        if 'last_checked' in hosts_data:
            last_checked = hosts_data['last_checked']
        logger.info('last checked: {}'.format(last_checked))
        logger.info('ts from rtmr: {}'.format(ts))
        # if args.debug:
        #     pdb.set_trace()
        tsq = (ts - last_checked) / 60
        logger.info('tsq: {}'.format(tsq))
        for event in counter:
            if key in hosts_data and event in hosts_data[key]:
                logger.info('hosts_data on {}: {}'.format(
                    event, hosts_data[key][event]))
                logger.info('current counter for {}: {}'.format(
                    event, counter[event]))
                diffdict[event] = int(
                    safediv((counter[event] - hosts_data[key][event]), tsq))
                logger.info('diffdict entry: {}'.format(diffdict[event]))
            else:
                diffdict[event] = int(safediv(counter[event], tsq))

        for event in diffdict:
            if diffdict[event] < 0:
                diffdict[event] = 0
                MOZHNO = False
            else:
                MOZHNO = True
            if diffdict[event] > 10000000 and not 'promofooter' in key:
                diffdict[event] = 10000000
            logger.info('{} push to razladki: {} = {}'
                        .format(
                            'Will' if MOZHNO else 'Won\'t',
                            'atom_host_{}_{}'.format(key, event),
                            diffdict[event]
                        ))
            if event != 'show':
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_host_{}_{}rate'.format(key, event),
                                (diffdict[event] / diffdict['show']
                                 if diffdict['show'] else 0)
                            ))
            if event == 'close' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_host_{}_clickcloserate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            if event == 'install' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_host_{}_clickinstallrate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            if MOZHNO:
                push_to_razladki(
                    params,
                    'atom_host_{}_{}'.format(key, event),
                    diffdict[event])
                if event != 'show':
                    push_to_razladki(
                        params,
                        'atom_host_{}_{}rate'.format(key, event),
                        (diffdict[event] / diffdict['show']
                            if diffdict['show'] else 0))
                if event == 'close' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_host_{}_clickcloserate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))
                if event == 'install' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_host_{}_clickinstallrate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))

        hosts_data[key] = dict(counter)

    # if args.debug:
    #     pdb.set_trace()
    hosts_data['last_checked'] = ts
    logger.info('will write to hosts data: {}'.format(ts))
    open('hosts_data.json', 'w').write(
        json.dumps(hosts_data))

    for key in ALLKEYS:
        req = None
        while (((req is None)
                or (req.status_code != 200))
               and ((dtdt.now() - start).total_seconds() < 3600)):
            logger.info('checking {}'.format(key))
            req = requests.get(
                'http://rtmr-sas-000.search.yandex.net:8080/yandsearch?view=json&table=atom/candidate_scores&key={}&maxrecords=1'.format(key))
            ts = arrow.now().to('Europe/Moscow').timestamp
            # ts = int((dtdt.now() - dtdt(1970, 1, 1)).total_seconds())
            # if args.debug:
            # pdb.set_trace()
        try:
            atomjson = json.loads(
                json.loads(req.content)['Entries'][0]['Value'])
            # ts = (9223372036854775807 -
            #     int(json.loads(req.content)['Entries'][0]['SubKey']))
        except:
            logger.error('Error while parsing json: {}'.format(
                req.content.decode('utf8', errors='replace')))
            continue

        counter = Counter()
        if atomjson and len(atomjson) > 0:
            candidate = sorted(atomjson, key=len)[0]
            valdict = valparse(atomjson[candidate].get('v', ''))
            # ts = 9223372036854775807 - atomjson[candidate]['ts']
            ts = arrow.now().to('Europe/Moscow').timestamp
            for event in valdict:
                if event in EVENTS:
                    counter[event] += int(valdict[event])
                else:
                    counter['unknown'] += int(valdict[event])
        else:
            logger.error('{} is null'.format(key))
            continue

        diffdict = Counter()
        last_checked = 1444149231
        if 'last_checked' in candidates_data:
            last_checked = candidates_data['last_checked']
        tsq = (ts - last_checked) / 60
        for event in counter:
            if key in candidates_data and event in candidates_data[key]:
                diffdict[event] = int(
                    safediv((counter[event] - candidates_data[key][event]), tsq))
            else:
                diffdict[event] = int(safediv(counter[event], tsq))

        for event in diffdict:
            if diffdict[event] < 0:
                diffdict[event] = 0
            if diffdict[event] == 0:
                MOZHNO = False
            else:
                MOZHNO = True
            if diffdict[event] > 100000 and not 'promofooter' in key:
                diffdict[event] = 100000
            logger.info('{} push to razladki: {} = {}'
                        .format(
                            'Will' if MOZHNO else 'Won\'t',
                            'atom_{}_{}'.format(key, event),
                            diffdict[event]
                        ))
            if event != 'show':
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_{}_{}rate'.format(key, event),
                                (diffdict[event] / diffdict['show']
                                 if diffdict['show'] else 0)
                            ))
            if event == 'close' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_{}_clickcloserate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            if event == 'install' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_{}_clickinstallrate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            if MOZHNO:
                push_to_razladki(
                    params,
                    'atom_{}_{}'.format(key, event),
                    diffdict[event])
                if event != 'show':
                    push_to_razladki(
                        params,
                        'atom_{}_{}rate'.format(key, event),
                        (diffdict[event] / diffdict['show']
                            if diffdict['show'] else 0))
                if event == 'close' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_{}_clickcloserate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))
                if event == 'install' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_{}_clickinstallrate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))

        candidates_data[key] = dict(counter)

    candidates_data['last_checked'] = ts
    logger.info('will write to candidates data: {}'.format(ts))
    open('candidates_data.json', 'w').write(
        json.dumps(candidates_data))


if __name__ == "__main__":
    main()
