#!usr/bin/env python
#! -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import argparse
from mapreducelib import MapReduce, Record, TemporaryTable
import json
import pickle


class CheckString():

    def __call__(self, rec):
        key, subkey, value = (
            rec.key.decode('utf8', errors='replace'),
            rec.subkey.decode('utf8', errors='replace'),
            rec.value.decode('utf8', errors='replace'),
        )
        if 'service=maps.yandex' in value:
            yield rec


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('date')
    args = parser.parse_args()

    print('setting MR defaults')

    MapReduce.useDefaults(server='cedar00.search.yandex.net:8013',
                          verbose=False, username='tmp', usingSubkey=True)

    srctable = 'user_sessions/{}'.format(args.date)

    print('checking table {}'.format(srctable))

    if 1 == len(list(MapReduce.getSample(srctable, count=1))):

        print('will map from table {}'.format(srctable))
        cs = CheckString()

        dstt = 'tmp/sessions_maps{}'.format(args.date)

        print('mapping into {}'.format(dstt))
        MapReduce.runMap(cs,
                         srcTable=srctable, dstTable=dstt)

if __name__ == "__main__":
    main()
