#!/usr/bin/env python
#! -*- coding: utf-8 -*-
# 3DECb bbI/\ rowa
from __future__ import unicode_literals
from __future__ import division
import sys
import arrow
import os
import json
import copy
import toml
import codecs
import requests
import argparse
import datetime as dt
import smtplib
import pdb
import logging
from collections import Counter
from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email.MIMEText import MIMEText
from email.Utils import COMMASPACE, formatdate
from email import Encoders
from pecheny.moncommons import push_to_razladki
from datetime import datetime as dtdt

_file_ = None


def send_mail(send_from, send_to, subject, text, files=[], server="localhost"):
    assert isinstance(send_to, list)
    assert isinstance(files, list)

    msg = MIMEMultipart()
    msg['From'] = send_from
    msg['To'] = COMMASPACE.join(send_to)
    msg['Date'] = formatdate(localtime=True)
    msg['Subject'] = subject

    msg.attach(MIMEText(text.encode('utf8')))

    for f in files:
        part = MIMEBase('application', "octet-stream")
        part.set_payload(open(f, "rb").read())
        Encoders.encode_base64(part)
        part.add_header('Content-Disposition',
                        'attachment; filename="%s"' % os.path.basename(f))
        msg.attach(part)

    smtp = smtplib.SMTP(server)
    smtp.sendmail(send_from, send_to, msg.as_string())
    smtp.close()

URL = 'http://atom-admin.n.yandex-team.ru/atom/api/v1/'
i = 0


def get_token():
    with codecs.open('.atom_token', 'r') as f:
        return f.read().rstrip()

HEADERS = {'Authorization': 'Token {}'.format(get_token())}


def get_creatives(collection):
    req = requests.get(URL + 'collections/' + collection, headers=HEADERS)
    try:
        return json.loads(req.content.decode('utf8'))
    except json.decoder.JSONDecodeError:
        print('error on {}'.format(collection))

allkeys = get_creatives('all_keys')
ALLKEYS = set()
for x in allkeys:
    if isinstance(x, basestring):
        ALLKEYS.add(x)
    elif isinstance(x, dict):
        for y in x[next(iter(x.keys()))]:
            ALLKEYS.add(y)
ALLKEYS = list(ALLKEYS)

# ALLKEYS = [
#     "distr_wizard_by",
#     "distr_wizard_ua",
#     "distr_wizard_kz",
# "distr_wizard_products_ru",
# "distr_wizard_products_tr",
#     "distr_wizard_tr",
# "_distr_wizard_ru",
# "_distr_wizard_old_ru",
# "news",
#     "service_block_ru",
#     "smart_banner_ru",
#     "smart_banner_test_ru",
#     "banana/1127_filtered",
#     "banana/images_wizard",
#     "banana/images_popup",
#     "images_distr_wizard_tr",
#     "banana/1141",
# "_distr_wizard_old_tmp_ru",
# "mobile_apps_ru",
# "distr_wizard_yabro_ru",
# "banana/1127_filtered_noname",
#     "banana/promofooter",
#     "banana/promofooter_mobile",
#     "banana/extensions_popup",
#     "banana/portal_popup",
#     "smartbanner_21101",
#     "smartbanner_21102",
#     "smartbanner_21103",
#     "smartbanner_21104",
#     "smartbanner_21105",
#     "smartbanner_21106",
#     "smartbanner_21107",
#     "distr_wizard_vnik_0",
#     "distr_wizard_vnik_1",
#     "distr_wizard_vnik_2",
#     "distr_wizard_proficit",
#     "distr_wizard_proficit_control",
#     "distr_stripe_proficit",
#     "distr_stripe_proficit_control",
#     "portal_popup_copy_minusservice",
#     "portal_popup_copy_minusservice_prod",
#     "altsearch_ru",
#     "portal_popup_copy",
#     "portal_popup_copy2",
#     "banana/daas_stripe",
#     "portal_popup_teaser_exp",
#     "touch_teaser",
#     "portal_teaser",
# "portal_popup_tr",
#     "stripe_teaser_exp",
#     "distr_wizard_ru",
#     "distr_wizard_ru_trueinstalls_prod",
#     "distr_wizard_ru_trueinstalls_exp",
#     "portal_popup_trueinstall_prod",
#     "portal_popup_trueinstall_exp",
# "smart_banner_yabro_ru"
# ]

ALLHOSTS = [
    'portal_popup',
    'altsearch',
    'bannerteaser',
    'images_wizard',
    'images_popup',
    'extp_popup',
    'dayuse_popup',
    'install_popup',
    'teaser_exp_newformula',
    'softlink',
    'promofooter',
    'promofooter_mobile',
    'smart-banner',
    'teaser',
    'teaser_exp',
    'distr_stripe_exp',
    'distr_stripe_prod',
    'portal_popup_exp',
    'portal_popup_prod',
    'smart-banner_exp',
    'smart-banner_prod',
    'mobilefooter',
    # 'daas',
    'vb_stripe',
    'promolib_dumpall',
    'vb_popup',
    'daas_stripe',
    'daas_band',
    'default_search',
    'distr_stripe',
    'portal_popup_ti_prod',
    'portal_popup_ti_exp',
    'default_search_ti_prod',
    'default_search_ti_exp',
]

EVENTS = {'error', 'show', 'install',
          'close', 'click', 'close_stripe', 'cancel', 'showlanding', 'download',
          'SOFT_EXPORT_EVENT_install', 'EVENT_AD_INSTALL'}


def valparse(value):
    values = value.split()
    return {v.split('=')[0]: '='.join(v.split('=')[1:])
            for v in values}


def safediv(x, y):
    try:
        return x / y
    except ZeroDivisionError:
        return 0


def main():

    start = dtdt.now()
    ts = int((start - dtdt(1970, 1, 1)).total_seconds())
    global _file_
    global __file__                         # to fix stupid
    __file__ = os.path.abspath(__file__)    # __file__ handling
    _file_ = os.path.basename(__file__)     # in python 2
    os.chdir(os.path.dirname(__file__))
    params = toml.loads(open('distribution.toml').read())

    parser = argparse.ArgumentParser()
    parser.add_argument('--debug', action='store_true')
    parser.add_argument('--stats', action='store_true')
    args = parser.parse_args()

    logger = logging.getLogger(_file_[:-3])
    formatter = logging.Formatter('%(asctime)s | %(message)s')
    ch = logging.StreamHandler()
    logger.setLevel(logging.DEBUG)
    if args.debug:
        ch.setLevel(logging.DEBUG)
    else:
        ch.setLevel(logging.CRITICAL)
    ch.setFormatter(formatter)
    logger.addHandler(ch)
    fh = logging.FileHandler('{}/logs/{}-{}.log'.format(
        os.path.dirname(__file__), _file_[:-3], start),
        encoding='utf8')
    fh.setLevel(logging.DEBUG)
    fh.setFormatter(formatter)
    logger.addHandler(fh)

    MOZHNO = False
    if os.path.isfile('candidates_data.json'):
        try:
            candidates_data = json.loads(open('candidates_data.json').read())
        except:
            candidates_data = {}
        logger.info('candidates_data.json found')
        MOZHNO = True
    else:
        candidates_data = {}
    if os.path.isfile('hosts_data.json'):
        try:
            hosts_data = json.loads(open('hosts_data.json').read())
        except:
            hosts_data = {}
        logger.info('hosts_data.json found')
    else:
        hosts_data = {}

    for key in ALLHOSTS:
        req = None
        while (((req is None)
                or (req.status_code != 200))
               and ((dtdt.now() - start).total_seconds() < 3600)):
            logger.info('checking {}'.format(key))
            req = requests.get(
                'http://rtmr-sas-000.search.yandex.net:8080/yandsearch?view=json&table=atom/host_scores&key={}&maxrecords=1&mrs=999999999'.format(key))
            ts = arrow.now().to('Europe/Moscow').timestamp
            # ts = int((dtdt.now() - dtdt(1970, 1, 1)).total_seconds())
            # if args.debug:
            # pdb.set_trace()
        try:
            atomjson = json.loads(req.content)['Entries'][0]['Value']
            ts = (9223372036854775807 -
                  int(json.loads(req.content)['Entries'][0]['SubKey']))
        except:
            logger.error('Error while parsing json: {}'.format(
                req.content.decode('utf8', errors='replace')))
            continue

        counter = Counter()
        if atomjson and len(atomjson) > 0:
            candidate = sorted(atomjson, key=len)[0]
            valdict = valparse(atomjson)
            for event in valdict:
                if event in EVENTS:
                    counter[event] += int(valdict[event])
                else:
                    counter['unknown'] += int(valdict[event])
        else:
            logger.error('{} is null'.format(key))
            continue

        diffdict = Counter()
        last_checked = 1450096880
        if key not in hosts_data:
            hosts_data[key] = {}
        if 'last_checked' in hosts_data[key]:
            last_checked = hosts_data[key]['last_checked']
            logger.info('last_checked from hosts_data[{}] is {}'.format(
                key, last_checked))
        elif 'last_checked' in hosts_data:
            last_checked = hosts_data['last_checked']
            logger.info('last_checked from hosts_data is {}'.format(
                last_checked))
        else:
            logger.error("No last_checked in hosts_data")
        logger.info('last checked: {}'.format(last_checked))
        logger.info('ts from rtmr: {}'.format(ts))
        # if args.debug:
        #     pdb.set_trace()
        tsq = (ts - last_checked) / 60
        logger.info('tsq: {}'.format(tsq))
        if tsq < 1:
            tsq = 1
        for event in counter:
            if key in hosts_data and event in hosts_data[key]:
                logger.info('hosts_data on {}: {}'.format(
                    event, hosts_data[key][event]))
                logger.info('current counter for {}: {}'.format(
                    event, counter[event]))
                diffdict[event] = int(
                    safediv((counter[event] - hosts_data[key][event]), tsq))
                logger.info('diffdict entry: {}'.format(diffdict[event]))
            else:
                diffdict[event] = int(safediv(counter[event], tsq))

        if key == 'default_search':
            default_search = copy.deepcopy(diffdict)
        if key == 'distr_stripe':
            push_to_razladki(
                params,
                'atom_host_serp_show',
                diffdict['show'] + default_search['show'])
            logger.info('serp show: {}'.format(
                diffdict['show'] + default_search['show'])
            )
            push_to_razladki(
                params,
                'atom_host_serp_install',
                diffdict['install'] + default_search['install'])
            logger.info('serp install: {}'.format(
                diffdict['install'] + default_search['install'])
            )
            proficit = ((-0.01 * diffdict['show'])
                        + (-0.025 * default_search['show'])
                        + (100 * diffdict['install'])
                        + (100 * default_search['install']))
            logger.info('proficit: {}'.format(proficit))
            push_to_razladki(
                params,
                'atom_host_serp_proficit',
                proficit
            )
            push_to_razladki(
                params,
                'atom_host_default_search_proficit',
                (-0.025 * default_search['show'])
                + (100 * default_search['install'])
            )
            push_to_razladki(
                params,
                'atom_host_distr_stripe_proficit',
                (-0.001 * diffdict['show'])
                + (100 * diffdict['install'])
            )

        logger.info('ts is {}'.format(ts))
        for event in diffdict:
            if diffdict[event] < 0:
                logger.info('Negative diff: {}'.format(diffdict[event]))
                diffdict[event] = 0
            MOZHNO = True
            if diffdict[event] > 10000000 and not 'promofooter' in key:
                diffdict[event] = 10000000
            logger.info('{} push to razladki: {} = {}'
                        .format(
                            'Will' if MOZHNO else 'Won\'t',
                            'atom_host_{}_{}'.format(key, event),
                            diffdict[event]
                        ))
            if event != 'show':
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_host_{}_{}rate'.format(key, event),
                                (diffdict[event] / diffdict['show']
                                 if diffdict['show'] else 0)
                            ))
            if event == 'close' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_host_{}_rate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            if event == 'close' and 'click' in diffdict and 'show' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_host_{}_clickminuscloserate'.format(key),
                                ((diffdict['click'] - diffdict['close']) / diffdict['show']
                                 if diffdict['show'] else 0)
                            ))
            if event == 'install' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_host_{}_clickinstallrate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            # pdb.set_trace()
            if MOZHNO:
                push_to_razladki(
                    params,
                    'atom_host_{}_{}'.format(key, event),
                    diffdict[event])
                if event != 'show':
                    push_to_razladki(
                        params,
                        'atom_host_{}_{}rate'.format(key, event),
                        (diffdict[event] / diffdict['show']
                            if diffdict['show'] else 0))
                if event == 'close' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_host_{}_clickcloserate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))
                if event == 'close' and 'click' in diffdict and 'show' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_host_{}_clickminuscloserate'.format(key),
                        ((diffdict['click'] - diffdict['close']) / diffdict['show']
                            if diffdict['show'] else 0))
                if event == 'install' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_host_{}_clickinstallrate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))

        hosts_data[key] = dict(counter)
        logger.info('Setting hosts_data[{}] last_checked to {}'.format(
            key, ts))
        hosts_data[key]['last_checked'] = ts

    # if args.debug:
    #     pdb.set_trace()
    hosts_data['last_checked'] = ts
    logger.info('will write to hosts data: {}'.format(ts))
    open('hosts_data.json', 'w').write(
        json.dumps(hosts_data))

    logger.info('All keys: {}'.format('\n'.join(sorted(ALLKEYS))))

    for key in ALLKEYS:
        req = None
        while (((req is None)
                or (req.status_code != 200))
               and ((dtdt.now() - start).total_seconds() < 3600)):
            logger.info('checking {}'.format(key))
            req = requests.get(
                'http://rtmr-sas-000.search.yandex.net:8080/yandsearch?view=json&table=atom/candidate_scores&key={}&maxrecords=1&mrs=999999999'.format(key))
            ts = arrow.now().to('Europe/Moscow').timestamp
            # ts = int((dtdt.now() - dtdt(1970, 1, 1)).total_seconds())
            # if args.debug:
            # pdb.set_trace()
        try:
            atomjson = json.loads(
                json.loads(req.content)['Entries'][0]['Value'])
            ts = (9223372036854775807 -
                  int(json.loads(req.content)['Entries'][0]['SubKey']))
        except:
            logger.error('Error while parsing json: {}'.format(
                req.content.decode('utf8', errors='replace')))
            continue

        counter = Counter()
        if atomjson and len(atomjson) > 0:
            cands = [x for x in atomjson if '/' in x]
            if key == 'portal_popup_teaser_exp' and args.debug:
                pdb.set_trace()
            for cand in cands:
                valdict = valparse(atomjson[cand].get('v', ''))
                ts = arrow.now().to('Europe/Moscow').timestamp
                for event in valdict:
                    if event in EVENTS:
                        if key == 'portal_popup_copy_minusservice':
                            logger.info('minusservice {} {} == {}'
                                        .format(cand, event, int(valdict[event])))
                        counter[event] += int(valdict[event])
                    else:
                        counter['unknown'] += int(valdict[event])
        else:
            logger.error('{} is null'.format(key))
            continue

        diffdict = Counter()
        last_checked = 1444149231
        if key not in candidates_data:
            candidates_data[key] = {}
        if 'last_checked' in candidates_data[key]:
            last_checked = candidates_data[key]['last_checked']
            logger.info('last_checked from candidates_data[{}] is {}'.format(
                key, last_checked))
        elif 'last_checked' in candidates_data:
            last_checked = candidates_data['last_checked']
            logger.info('last_checked from candidates_data is {}'.format(
                last_checked))
        else:
            logger.error('No last_checked in candidates_data')
        tsq = (ts - last_checked) / 60
        logger.info('tsq: {}'.format(tsq))
        if tsq < 1:
            tsq = 1
        for event in counter:
            if key in candidates_data and event in candidates_data[key]:
                logger.info('candidates_data on {}: {}'.format(
                    event, candidates_data[key][event]))
                logger.info('current counter for {}: {}'.format(
                    event, counter[event]))
                diffdict[event] = int(
                    safediv((counter[event] - candidates_data[key][event]), tsq))
                logger.info('diffdict entry: {}'.format(diffdict[event]))
            else:
                diffdict[event] = int(safediv(counter[event], tsq))

        # dw_proficit = {}
        # if key == 'distr_wizard_proficit':
        #     dw_proficit = copy.deepcopy(diffdict)
        # if key == 'distr_stripe_proficit':
        #     push_to_razladki(
        #         params,
        #         'exp_proficit_serp_show',
        #         diffdict['show'] + dw_proficit['show'])
        #     logger.info('serp show: {}'.format(
        #         diffdict['show'] + dw_proficit['show'])
        #         )
        #     push_to_razladki(
        #         params,
        #         'exp_proficit_serp_install',
        #         diffdict['install'] + dw_proficit['install'])
        #     logger.info('serp install: {}'.format(
        #         diffdict['install'] + dw_proficit['install'])
        #         )
        #     proficit = ((-0.01*diffdict['show'])
        #         + (-0.025*dw_proficit['show'])
        #         + (100 * diffdict['install'])
        #         + (100 * dw_proficit['install']))
        #     logger.info('proficit: {}'.format(proficit))
        #     push_to_razladki(
        #         params,
        #         'exp_serp_proficit',
        #         proficit
        #         )
        #     push_to_razladki(
        #         params,
        #         'exp_default_search_proficit',
        #         (-0.025*default_search['show'])
        #         + (100 * default_search['install'])
        #         )
        #     push_to_razladki(
        #         params,
        #         'exp_host_distr_stripe_proficit',
        #         (-0.001*diffdict['show'])
        #         + (100 * diffdict['install'])
        #         )
        # if key == 'distr_wizard_proficit_control':
        #     dw_proficit_control = copy.deepcopy(diffdict)
        # if key == 'distr_stripe_proficit_control':
        #     push_to_razladki(
        #         params,
        #         'exp_proficit_control_serp_show',
        #         diffdict['show'] + dw_proficit_control['show'])
        #     logger.info('serp show: {}'.format(
        #         diffdict['show'] + dw_proficit_control['show'])
        #         )
        #     push_to_razladki(
        #         params,
        #         'exp_proficit_control_serp_install',
        #         diffdict['install'] + dw_proficit_control['install'])
        #     logger.info('serp install: {}'.format(
        #         diffdict['install'] + dw_proficit_control['install'])
        #         )
        #     proficit = ((-0.01*diffdict['show'])
        #         + (-0.025*dw_proficit_control['show'])
        #         + (100 * diffdict['install'])
        #         + (100 * dw_proficit_control['install']))
        #     logger.info('proficit: {}'.format(proficit))
        #     push_to_razladki(
        #         params,
        #         'exp_serp_proficit_control',
        #         proficit
        #         )
        #     push_to_razladki(
        #         params,
        #         'exp_default_search_proficit_control',
        #         (-0.025*default_search['show'])
        #         + (100 * default_search['install'])
        #         )
        #     push_to_razladki(
        #         params,
        #         'exp_host_distr_stripe_proficit_control',
        #         (-0.001*diffdict['show'])
        #         + (100 * diffdict['install'])
        #         )
        for event in diffdict:
            if diffdict[event] < 0:
                logger.info('Negative diff: {}'.format(diffdict[event]))
                diffdict[event] = 0
            MOZHNO = True
            if diffdict[event] > 100000 and not 'promofooter' in key:
                diffdict[event] = 100000
            logger.info('{} push to razladki: {} = {}'
                        .format(
                            'Will' if MOZHNO else 'Won\'t',
                            'atom_{}_{}'.format(key, event),
                            diffdict[event]
                        ))
            if event != 'show':
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_{}_{}rate'.format(key, event),
                                (diffdict[event] / diffdict['show']
                                 if diffdict['show'] else 0)
                            ))
            if event == 'close' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_{}_clickcloserate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            if event == 'close' and 'click' in diffdict and 'show' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_{}_clickminuscloserate'.format(key),
                                ((diffdict['click'] - diffdict[event]) / diffdict['show']
                                 if diffdict['show'] else 0)
                            ))
            if event == 'install' and 'click' in diffdict:
                logger.info('{} push to razladki: {} = {}'
                            .format(
                                'Will' if MOZHNO else 'Won\'t',
                                'atom_{}_clickinstallrate'.format(key),
                                (diffdict[event] / diffdict['click']
                                 if diffdict['click'] else 0)
                            ))
            if MOZHNO:
                push_to_razladki(
                    params,
                    'atom_{}_{}'.format(key, event),
                    diffdict[event])
                if event != 'show':
                    push_to_razladki(
                        params,
                        'atom_{}_{}rate'.format(key, event),
                        (diffdict[event] / diffdict['show']
                            if diffdict['show'] else 0))
                if event == 'close' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_{}_clickcloserate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))
                if event == 'close' and 'click' in diffdict and 'show' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_{}_clickminuscloserate'.format(key),
                        ((diffdict['click'] - diffdict[event]) / diffdict['show']
                            if diffdict['show'] else 0))
                if event == 'install' and 'click' in diffdict:
                    push_to_razladki(
                        params,
                        'atom_{}_clickinstallrate'.format(key),
                        (diffdict[event] / diffdict['click']
                            if diffdict['click'] else 0))

        candidates_data[key] = dict(counter)
        logger.info('Setting candidates_data[{}] last_checked to {}'.format(
            key, ts))
        candidates_data[key]['last_checked'] = ts

    candidates_data['last_checked'] = ts
    logger.info('will write to candidates data: {}'.format(ts))
    open('candidates_data.json', 'w').write(
        json.dumps(candidates_data))


if __name__ == "__main__":
    main()
