#!/usr/bin/env python
#! -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import requests
import datetime as dt
import smtplib
from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email.MIMEText import MIMEText
from email.Utils import COMMASPACE, formatdate
from email import Encoders
from datetime import datetime as dtdt


def send_mail(send_from, send_to, subject, text, files=[], server="localhost"):
    assert isinstance(send_to, list)
    assert isinstance(files, list)

    msg = MIMEMultipart()
    msg['From'] = send_from
    msg['To'] = COMMASPACE.join(send_to)
    msg['Date'] = formatdate(localtime=True)
    msg['Subject'] = subject

    msg.attach(MIMEText(text.encode('utf8')))

    for f in files:
        part = MIMEBase('application', "octet-stream")
        part.set_payload(open(f, "rb").read())
        Encoders.encode_base64(part)
        part.add_header('Content-Disposition',
                        'attachment; filename="%s"' % os.path.basename(f))
        msg.attach(part)

    smtp = smtplib.SMTP(server)
    smtp.sendmail(send_from, send_to, msg.as_string())
    smtp.close()


def main():
    r = None
    start = dtdt.now()
    while ((r is None) or
           (r.status_code != 200)) and ((dtdt.now() - start).total_seconds() < 3600):
        r = requests.get(
            'http://suggest-market.yandex.net/suggest-dict-info')
    cont = r.content.decode('utf8', errors='replace').split('\n')
    for line in cont:
        if line.startswith('user_buckets'):
            ts = int(line.split()[0].split('.')[1])
            diffdays = (dtdt.now() - dtdt.fromtimestamp(ts)).days
            if diffdays > 5:
                send_mail(
                    send_from='userbuckets@monitoring1.haze.yandex.net',
                    send_to=['pecheny@yandex-team.ru',
                             'qkrorlqr@yandex-team.ru'],
                    subject='Userbuckets age/size monitoring',
                    text='User_buckets are {} days old (dated {})'
                    .format(diffdays,
                            dtdt.fromtimestamp(ts).strftime(
                                '%Y-%m-%d %H:%M:%S')))
            else:
                pass


if __name__ == "__main__":
    main()
