#!/usr/bin/env python
#! -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import re
import json
import codecs
import argparse
import requests
import datetime
import pdb
import urllib
from pytils import yt_get_date_from_table, yt_config_set_defaults
import yt.wrapper as yt





STAT_HEADERS = {'StatRobotUser': 'robot_pecheny',
'StatRobotPassword': 'OoGh1Adahy'}
STAT_URL = 'https://stat.yandex-team.ru/Distribution/Others/AtomBanners/v4_daily?scale=d&period_distance=1&_type=json'

def get_last_sessions():
    tis = sorted(yt.list('//statbox/redir-log'))
    today = datetime.date.today()
    tis = [x for x in tis
           if yt_get_date_from_table(x) <= datetime.date.today()]
    return yt_get_date_from_table(tis[-1])


def get_last_stat():
    req = requests.get(STAT_URL, headers=STAT_HEADERS)
    return datetime.datetime.strptime(
        json.loads(req.content.decode('utf8'))['values'][0]['fielddate'],
        '%Y-%m-%d %H:%M:%S'
        ).date()

def main():
    yt_config_set_defaults(yt, None)
    lastsessions = get_last_sessions()
    laststat = get_last_stat()
    if (lastsessions - laststat).days > 2:
        send_sms(['pecheny'], 'Last sessions: {}, last v4_daily: {}'
            .format(lastsessions, laststat))

if __name__ == "__main__":
    main()
