#!/usr/bin/env python
#! -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import mapreducelib
from mapreducelib import MapReduce, Record, SubkeyedRecord
from collections import defaultdict, Counter


def parseparams(value):
    tabs = value.split('\t')
    result = {}
    for x in tabs:
        if len(x.split('=')) > 1:
            result[x.split('=')[0]] = '='.join(x.split('=')[1:])
        else:
            result[x] = 'SINGLE'
    return defaultdict(lambda: '', result)


def deutf8ify(rec):
    if isinstance(rec, mapreducelib.SubkeyedRecord):
        key, subkey, value = rec.key, rec.subkey, rec.value
        if not isinstance(key, unicode):
            key = key.decode('utf8', errors='replace')
        if not isinstance(subkey, unicode):
            subkey = subkey.decode('utf8', errors='replace')
        if not isinstance(value, unicode):
            value = value.decode('utf8', errors='replace')
        return Record(key, subkey, value)
    if isinstance(rec, mapreducelib.SimpleRecord):
        key, value = rec.key, rec.value
        if not isinstance(key, unicode):
            key = key.decode('utf8', errors='replace')
        if not isinstance(value, unicode):
            value = value.decode('utf8', errors='replace')
        return Record(key, value)
    elif isinstance(rec, str):
        rec = rec.decode('utf8', errors='replace')
    return rec


def utf8ify(rec):
    if isinstance(rec, mapreducelib.SubkeyedRecord):
        if isinstance(rec.key, unicode):
            rec.key = rec.key.encode('utf8')
        if isinstance(rec.subkey, unicode):
            rec.subkey = rec.subkey.encode('utf8')
        if isinstance(rec.value, unicode):
            rec.value = rec.value.encode('utf8')
        return rec
    elif isinstance(rec, mapreducelib.SimpleRecord):
        if isinstance(rec.key, unicode):
            rec.key = rec.key.encode('utf8')
        if isinstance(rec.value, unicode):
            rec.value = rec.value.encode('utf8')
        return rec
    elif isinstance(rec, unicode):
        rec = rec.encode('utf8')
    return rec


def get_param(s, compiled_regex):
    if compiled_regex.search(s):
        return compiled_regex.search(s).group(0)


def LOAD(x):
    return pickle.load(open(x, 'rb'))


def DUMP(x, filename):
    return pickle.dump(x, open(filename, 'wb'))


def make_test_record(s):
    return Record(
        s.split('\t')[0], s.split('\t')[1], '\t'.join(s.split('\t')[2:]))


def prepare_records_for_reduce(recs):
    keys = set(rec.key for rec in recs)
    for key in keys:
        yield (key, sorted([rec for rec in recs if rec.key == key]))


def flatten_list(list_):
    result = []
    for item_ in list_:
        if isinstance(item_, list):
            result.extend(flatten_list(item_))
        else:
            result.append(item_)
    return result


def normalize_clid(clid):
    result = clid
    result = re.sub(r'\-[0-9]+', '', result)
    result = re.sub(r'[^0-9]', '', result)
    return result


def ymd(date):
    return date.strftime('%Y%m%d')


def y_m_d(date):
    return date.strftime('%Y-%m-%d')


def tryint(s):
    try:
        return int(s)
    except:
        return -1


def tryint_none(s):
    try:
        return int(s)
    except:
        return None


def main():
    pass


def table_exists(table, maxretries=3):
    retries = 0
    while retries < maxretries:
        if len(list(MapReduce.getSample(table, count=1))) == 1:
            return True
        else:
            retries += 1
    return False

if __name__ == "__main__":
    main()
