import sys

_REGIONS = {
    'ru': 225,
    'by': 149,
}

def _get_import_flags_node(banner):
    return banner.setdefault('__atom_import_flags', {})

def check_regions(banner, regions):
    if isinstance(regions, str):
        regions = [regions]
    for reg in regions:
        assert 'aux-data' in banner, 'no aux in banner!'
        descr_parts = banner.get('aux-data', {}).get('_description', '').split('_')
        if reg.upper() in descr_parts:
            return True
        reg_id = _REGIONS[reg.lower()]
        filter_sub = '#lr,eq,{}'.format(reg_id)
        if filter_sub in banner.get('filter', ''):
            return True
    return False

def disable_age_check_in_sandbox(banner):
    _get_import_flags_node(banner)['skip_age_check'] = 1

def get_age_check_in_sandbox(banner):
    return _get_import_flags_node(banner).get('skip_age_check', 0)


def remove_params_with_curly_brackets(link):
    try:
        url, params = link.split('?')
        brackets = ['{', '}', '%7B', '%7D']
        params = params.split('&')
        params = list(filter(lambda x: not any(br in x for br in brackets), params))
        clean = '?'.join([url, '&'.join(params)])
        return clean
    except:
        return link

