import pytest
import json
from common import check_regions, disable_age_check_in_sandbox

def test_check_region_exception_on_empty_banner():
    with pytest.raises(Exception):
        check_regions({}, 'RU')

def test_check_region_in_title():
    tests = [
        ('BY', {'aux-data': {'_description':"b_BY_m"}}, True),
        ('BY', {'aux-data': {'_description':"b_by_m"}}, False),
        ('BY', {'aux-data': {'_description':"bBYm"}}, False),
        ('BY', {'aux-data': {'_description':"BY"}}, True),
    ]
    tests += [(region.lower(), banner, res) for region, banner, res in tests]
    lists = [([region], banner, res) for region, banner, res in tests]
    double_lists = [([region] + ['RU'], banner, res) for region, banner, res in tests]

    for region, banner, res in tests + lists + double_lists:
        assert check_regions(banner, region) == res

def test_check_region_in_filter():
    tests = [
        ('BY', {'aux-data': {'_description':""}, 'filter':{'#abc'}}, False),
        ('BY', {'aux-data': {'_description':""}, 'filter':{'#lr,eq,149'}}, True),
        ('BY', {'aux-data': {'_description':""}, 'filter':{'lr,eq,149'}}, False),
        ('BY', {'aux-data': {'_description':""}, 'filter':{'#lr,eq,225'}}, False),
        (['BY', 'RU'], {'aux-data': {'_description':""}, 'filter':{'#lr,eq,225'}}, True),
        ('BY', {'aux-data': {'_description':""}, 'filter':{'#ref,eq,149'}}, False),
    ]

    for region, banner, res in tests:
        assert check_regions(banner, region) == res

def test_disable_age_check_in_sandbox():
    b = {}
    disable_age_check_in_sandbox(b)
    assert b == {'__atom_import_flags': {'skip_age_check': 1}}

    b = {'__atom_import_flags': {'a':'b'}}
    disable_age_check_in_sandbox(b)
    assert b == {'__atom_import_flags': {'skip_age_check': 1, 'a': 'b'}}
