#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import re
import os
import sys
from copy import deepcopy
from place import Place

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))
from parser_filters import pack, parse
from delete_defaults_filters import delete_defaults


class Daas_stripe(Place):
    def del_invalid_params(self, url):
        def invalid_param(param):
            invalid_symbols = ('{', '}',)
            return any(symbol in param for symbol in invalid_symbols)
        try:
            assert '?' in url
        except AssertionError:
            return url
        url, params = url.split('?')
        params = params.replace('%7B', '{').replace('%7D', '}')
        params = [
            param for param in params.split('&') if not invalid_param(param)
        ]
        clean = '?'.join([url, '&'.join(params)])
        return clean

    def customFormat(self, k):
        self.fields_for_features.update({
            "button_type": "type",
            "background_color": "background",
            "button": "yes",
            "button_url": "link",
            "type": "type"
        })
        mobile_linkextension = {
            "af_sub5": "uid",
            "atom_bannerid": "$banner_id",
            "atom_reqid": "reqid",
            "banerid": "showid",
            "host": "$host",
            "yandexuid": "uid",
        }
        aux = k['aux-data']
        _description = aux["_description"]
        if not aux.get('button_url'):
            return
        product_parsed_from_description = _description.split("_")[0].lower()
        k["__product"] = aux.get('product')
        k['__product'] = k['__product'] or product_parsed_from_description
        aux['product'] = k['__product']

        aux['button_url'] = self.del_invalid_params(aux['button_url'])
        is_appsflyer = 'appsflyer' in aux['button_url']
        is_appmetrica = 'appmetrica' in aux['button_url']
        if is_appsflyer or is_appmetrica:
            k["bandits-weight-expression"] = "(1+EVENT_AD_INSTALL+install)"
            k["fml-weight-expression"] = "MOBLTV"
        else:
            k["bandits-weight-expression"] = "(1+SOFT_EXPORT_EVENT_install)"
            # fixed "fml-weight-expression", so weights become equal to ones, described in
            # https://st.yandex-team.ru/PERSONAL-1797
            # took weight from https://a.yandex-team.ru/arc/trunk/arcadia_tests_data/pers/rerank_service/data/bandit_vars.txt?rev=3771163
            # (the biggest one for each product)
            custom_multiplier  = {
                "browser" : "1.0",   # 1.5 -> 1.5
                "sethome" : "5.0",   # 0.4 -> 2.0
                "set"     : "7.5",   # 0.2 -> 1.5
                "home"    : "5.0",   # 0.2 -> 1.0
                "vb"      : "5.0"    # 0.2 -> 1.0
            }
            if k['__product'] in custom_multiplier.keys():
                k["fml-weight-expression"] = "{mult}*LTV".format(mult=custom_multiplier[k['__product']])
            else:
                k["fml-weight-expression"] = "LTV"
        if aux['button_type'] == 'landing':
            if is_appsflyer or is_appmetrica:
                aux["_link_extensions"] = {"button_url": mobile_linkextension}
            else:
                aux["_link_extensions"] = {"button_url": self.linkextension}
        if '&banerid=' in aux.get('button_url', ''):
            aux['button_url'] = re.sub(pattern='&banerid=[0-9]+',
                                       repl='',
                                       string=aux['button_url'])
        try:
            if (
                aux.get('background_image') and
                'https://yabs.yandex.ru/resource/https://avatars'
                    in aux['background_image']
            ):
                aux['background_image'] = aux['background_image'].split(
                    '/resource/')[1]
        except:
            print aux
            raise
        try:
            k["title"] = aux["text"]
        except KeyError:
            self.logger.info(json.dumps(k, encoding='utf-8').encode('utf-8'))
            return
        k.pop("bandits-weight", None)
        k["grouping-key"] = "distribution"
        # by convention virus creatives ae not imported from banana
        if k["__product"] == "virus":
            return
        # --<-| Do not import links of vz-kinipoisk |->--
        if 'vz_kinopoisk' in aux['button_url']:
            return
        if 'mail' in _description \
            and ('translate' not in _description and
                 'video' not in _description):
            aux['position_style'] = 'relative'

        # Validation
        position_style = aux['position_style']
        position_type = aux['position_type']

        is_relative = position_style == 'relative'
        is_fixed = not is_relative
        is_bottom = position_type == 'bottom'
        is_top = position_type == 'top'

        description_without_product = '_'.join(_description.split('_')[1:])
        is_autoru = 'auto' in description_without_product
        is_disk = 'disk' in description_without_product
        is_images = 'images' in description_without_product
        is_kinopoisk = ',match,http://www.kinopoisk' in k['filter']
        is_maps = 'maps' in description_without_product
        is_mail = 'mail' in description_without_product
        is_music = 'music' in description_without_product
        is_news = 'news' in description_without_product
        is_pogoda = ('pogoda' in description_without_product)\
            or ('weather' in description_without_product)
        is_translate = 'translate' in description_without_product
        is_video = 'video' in description_without_product

        prohibited_placements = [
            is_autoru and is_bottom,
            is_autoru and is_fixed,
            is_disk and is_bottom,
            is_images and is_bottom,
            is_kinopoisk and is_top,
            is_mail and is_bottom,
            is_mail and is_fixed,
            is_music and is_bottom,
            is_translate and is_bottom,
            is_video and is_bottom,
        ]
        if is_autoru:
            k['ignore-default-filters'] = 1
            k['filter'] = "&".join(
                [k['filter'],
                 "('#feat:527,gt,0.9824'|'#feat:527,eq,0')"]
            )
        # End validation
        k['aux-data'] = aux
        k['filter'] = pack(delete_defaults(k['filter']))
        k['filter'] = '&'.join(term for term in set(k['filter'].split('&'))
                               if 'clid' not in term)
        if aux['product'] == 'searchline':
            k['filter'] += "&'#ua,ic_match,%windows%'&'#uat:isMobile,eq,false'&'#uat:BrowserName,eq,YandexBrowser'"
        self.allowed.append('auto')
        if k["__product"] in self.allowed and not any(prohibited_placements):
            return k

    def make_daas_text_subst(self):
        def make_single_subst(_filter, _data):
            return {'filter': _filter, 'data': _data}

        text_subst = {
            'position': [],
            'install_text': [],
        }
        for _filter, position, install_text in (
            (
                "'#uat:BrowserName,eq,Chrome'",
                'left_bottom',
                self.install_text_ch,
            ),
            (
                "'#uat:BrowserName,eq,Edge'",
                'center_bottom',
                self.install_text_ie,
            ),
            (
                "'#uat:BrowserName,eq,MSIE'",
                'center_bottom',
                self.install_text_ie,
            ),
            # (
            #     "'#uat:BrowserName,eq,Firefox'",
            #     'right_top',
            #     self.install_text_ff,
            # ),
            # (
            #     "'#uat:BrowserName,eq,Opera'",
            #     'right_top',
            #     self.install_text_opr,
            # ),
            (
                "default",
                '',
                u'Нажмите на загруженный файл',
            ),
        ):
            text_subst['position'].append(
                make_single_subst(_filter, position)
            )
            text_subst['install_text'].append(
                make_single_subst(_filter, install_text)
            )
        return text_subst

    def clone_with_veil(self, k, param):
        # nonchanging_tld = ('auto.ru', 'disk.yandex.ru', 'kinopoisk.ru')
        clone = deepcopy(k)
        lr_tld = {'225': 'ru', '187': 'ua', '149': 'by', '159': 'kz'}
        aux = clone["aux-data"]

        def lrs_from_description(desc):
            desc = desc.strip().split('_')
            lrs = [i.split('lr')[1] for i in desc if i.startswith('lr')]
            return lrs

        def make_subst(_filter, lr):
            flt = _filter.replace('yandex.ru', 'yandex.{}'.format(lr_tld[lr]))\
                .replace("('#lr,eq,977'|'#lr,eq,225')",
                         "'#lr,eq,{}'".format(lr))\
                .replace("'#lr,eq,225'", "('#lr,eq,977'|'#lr,eq,225')")
            data = lr_tld[lr]
            return {'filter': flt, 'data': data}

        def subst_age(lr):
            if lr == '225':
                return {'filter': "('#lr,eq,977'|'#lr,eq,225')", 'data': '0+'}
            else:
                return {'filter': "'#lr,eq,{}'".format(lr), 'data': ''}

        # Prefilters
        # Dont clone if not browser
        if clone['__product'] != 'browser':
            return
        # Don't clone if original filter does not contain lr=225 AND yandex.ru
        if any(sub not in clone['filter']
               for sub in ('#lr,eq,225', 'yandex.ru')):
            return

        # Modifiers
        aux['text'] = aux['text'].replace('.ru', '').replace('0+', '')
        clone['text-subst'] = self.make_daas_text_subst()
        clone['text-subst']['tld'] = []
        clone['text-subst']['age_restriction'] = []
        for lr in lrs_from_description(aux['_description']):
            clone['text-subst']['tld'].append(
                make_subst(_filter=clone['filter'], lr=lr))
            clone['text-subst']['age_restriction'].append(subst_age(lr))

        desc = u'<br><br>После этого начнётся установка Яндекс.Браузера'
        for idx, _ in enumerate(clone['text-subst']['install_text']):
            clone['text-subst']['install_text'][idx]['data'] += desc

        aux['subst-fields'] = [
            'age_restriction',
            'agreement_url',
            'arrow_position',
            'button_url',
            'install_text',
        ]
        aux['_description'] += '_subst'
        aux["_link_extensions"] = {"button_url": {"banerid": "showid"}}
        aux['age_restriction'] = '${age_restriction}'
        aux['agreement_text'] = ", ".join([
            "Устанавливая Яндекс.Браузер",
            "вы принимаете условия лицензионного соглашения"
        ])
        aux['agreement_url'] = 'https://yandex.${tld}/legal/browser_agreement'
        aux['arrow_position'] = '${position}'
        aux['button_type'] = "download_inline"
        aux['button_url'] = clone['link'] = '//browser.yandex.${tld}/download'
        aux['install_text'] = '${install_text}'
        clone['aux-data'] = aux
        clone['filter'] = "'#uat:isMobile,eq,false'"
        return clone
