#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys, os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))
from parser_filters import pack, parse
from delete_defaults_filters import delete_defaults, detect_device_target
from place import Place


class Mobilefooter(Place):
    def clean_link(self, link):
        try:
            url, params = link.split('?')
            params = params.replace('%7B', '{').replace('%7D', '}')
            params = [
                param for param in params.split('&')
                if not any([curly_bracket in param
                            for curly_bracket in ('{', '}',)])
            ]
            clean = '?'.join([url, '&'.join(params)])
            return clean
        except:
            return link


    def customFormat(self, k):
        if not k.get('aux-data').get('link'):
            return
        self.fields_for_features.update({
            "logo": "image",
            "background": "background",
            "link": "link"
        })

        self.linkextension = {
            "atom_reqid": "reqid",
            "atom_bannerid": "$banner_id",
            "banerid": "showid",
            "host": "$host",
            "yandexuid": "uid"
        }
        k["fml-weight"] = 100500
        k["bandits-weight-expression"] = "MOBLTV*(10*EVENT_AD_INSTALL+10*install+real_click)+1"
        k["grouping-key"] = "no_grouping"
        k["__product"] = k["aux-data"]["data_for_counter_product"]
        # PERSONAL-1836
        # if k["__product"] in ('launcher'):
        #     return

        # do not ban applsflyer if mobilefooter/music
        if k['aux-data']['_atom_url'] != "mobilefooter/music" and 'appsflyer' in k['aux-data']['link']:
            return
        if not 'text' in k['aux-data']:
            k["title"] = k["aux-data"]["title"]
        else:
            k["title"] = k["aux-data"]["text"]
        k["snippet"] = k[
            "aux-data"]["description"] if "snippet" in k["aux-data"].keys() else ""
        k["__textauthor"] = k[
            "aux-data"]["textauthor"] if "textauthor" in k["aux-data"].keys() else ""

        k["aux-data"]["_link_extensions"] = {"link": self.linkextension}
        k["aux-data"]['_atom_url'] = k["aux-data"]['_atom_url'].split('/')[0] + '/' + k["__product"]
        k['aux-data']['link'] = self.clean_link(k['aux-data']['link'])
        if "search-bot.yandex.net" in k["aux-data"]["link"]:
            k["aux-data"]["_link_extensions"] = {"link": {"lr": "lr"}}
        # optimize filters
        platform_target = detect_device_target(k)
        k['filter'] = pack(delete_defaults(k['filter']))
        if platform_target:
            if k['filter']:
                k['filter'] += "&" + platform_target
            else:
                k['filter'] += platform_target
        return k
