#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division

import datetime
import hashlib
import json
import math
import os
import re
import requests
import subprocess
import sys
import time
import urllib
from operator import itemgetter
from random import shuffle
from collections import Counter


def tabulate(*args):
    return '\t'.join(map(format, args))


def get_token():
    with open('vault/.atom_admin_token', 'r') as f:
        return f.readline().strip()


def now():
    return datetime.datetime.now().strftime(format="%Y-%m-%d_%H-%M-%S")


class DummyLogger(object):

    def info(self, s):
        pass

    def debug(self, s):
        pass

    def error(self, s):
        pass

    def warning(self, s):
        pass


class Place:
    def __init__(self, params):
        self.logger = params.get('logger', DummyLogger())
        self.logger.info("Start process classname: {}".format(params["classname"]))
        self.logger.info('params: {}'.format(params))
        self.lock = params["lock"]
        self.clones = []
        self.clones_with_styles = []
        self.originals_to_remove_after_cloning = []
        self.originals_to_remove_after_duplicating_styles = []
        self.placeid = params["placeid"]
        self.collection = params["collection"]
        self.hostname = params["host"]
        self.do = params["do"] if "do" in params else True
        self.included_orders = params.get("included_orders", [])
        self.excluded_orders = params.get("excluded_orders", [])
        self.mask = 'https://avatars.mds.yandex.net/get-serp/{}/orig'
        self.nofiltering = params["nofiltering"].lower() in (
            "yes", "true", "t", "1") if "nofiltering" in params else False
        self.zerogroup_default = params.get("zerogroup_default", 25)
        self.prefix = params.get("prefix", "")
        self.downloaddata = params["downloaddata"].lower() in (
            "yes", "true", "t", "1") if "downloaddata" in params else True
        self.upload = params["upload"].lower() in (
            "yes", "true", "t", "1") if "upload" in params else True
        self.validate = params["validate"].lower() in (
            "yes", "true", "t", "1") if "validate" in params else False
        self.verbose = params["verbose"].lower() in (
            "yes", "true", "t", "1") if "verbose" in params else False
        self.classname = params["classname"]
        self.verbose = params["verbose"].lower() in (
            "yes", "true", "t", "1") if "verbose" in params else False
        self.clone_browser = params.get("clone_browser", False)
        self.clone_styles = params.get("clone_styles", False)
        self.clone_for_country = params.get('clone_country', False)
        # self.clone_with_age_restriction = params.get('clone_age', False)

        self.allowed = [
            "browser",
            "home",
            "helper",
            "set",
            "sethome",
            "search",
            "vb",
            "virus"
        ]

        self.and_filters = {}
        self.or_filters = {}
        self.bad_contexts = set()
        self.all_contexts = set()
        self.used_bannerids = set()

        self.linkextension = {
            "reqid": "reqid",
            "banner_id": "$banner_id",
            "host": "$host",
            "banerid": "showid"
        }

        self.number_of_objects = 0
        self.bannerids = {}
        self.banners_stat = {}
        self.total_shows = 0
        self.contexts_banners = {}
        self.stat = lambda x: x[3]
        self.objects = []
        self.fields_for_features = {"type": "type"}

        self.base_filter = "&".join(["('#lr,eq,977'|'#lr,eq,225')", "'#lang,eq,ru'",
                                     "'#ua,ic_match,%windows%'", "'#uat:isMobile,eq,false'"])
        self.chrome_filter = "&".join([self.base_filter, "'#uat:BrowserName,eq,Chrome'"])
        self.msie_filter = "&".join([self.base_filter, "('#uat:BrowserName,eq,MSIE'|'#uat:BrowserName,eq,Edge')"])
        self.firefox_filter = "&".join([self.base_filter, "'#uat:BrowserName,eq,Firefox'"])
        self.opera_filter = "&".join([self.base_filter, "'#uat:BrowserName,eq,Opera'"])

        self.install_text_ch = u'Нажмите кнопку, на которую указывает стрелка.'
        self.install_text_ie = u'Нажмите кнопку «Выполнить» на панели внизу.'
        self.install_text_ff = u'Нажмите на синюю стрелку и выберите верхний файл.'
        self.install_text_opr = u'Нажмите на стрелку и выберите верхний файл.'
        self.install_text_default = u'Нажмите на последний скачанный файл в панели загрузок'

        self.install_desc_stroka = u'После этого начнётся установка Яндекс.Строки'
        self.install_desc_bro = u'После этого начнётся установка Яндекс.Браузера'

        self.clone_country_config = [
            {
                'country': 'by',
                'lr': '149',
                'set': 'bfbfnompmdfinceiocgbokojkolbmphe',
                'sethome': 'eoliomkficgdhbaoddnjinhfdmlifpcn',
                'home': 'igmkomkjgdghegagolfeaghfljmcfeak',
            },
            {
                'country': 'ua',
                'lr': '187',
                'set': 'ijbepmfgphlcbokeedcnmbedhckonlin',
                'sethome': 'cbagalopghhleggojlledjihpdbogmcn',
                'home': 'lpedlkoodagolnaladgccadeahpjgblg',
            },
            {
                'country': 'kz',
                'lr': '159',
                'set': 'pbhpmmlgceejicjkjadehdndidlbljdg',
                'sethome': 'cfimkhoocjgndidjimldlkkjdhpcjpjm',
                'home': 'negodbcgckiljcipakagghpkjnadnnog',
            },
            {
                'country': 'ru',
                'lr': '225',
                'set': 'laddjijkcfpakbbnnedbhnnciecidncp',
                'sethome': 'nehapofakghljopfegjogpgpeljkhjjn',
                'home': 'lalfiodohdgaejjccfgfmmngggpplmhp',
            },
        ]
        if self.do:
            self.getSessionid()
            self.collectStat()
            self.getUsedBanners()
            if self.downloaddata:
                self.downloadData()
            self.parseContexts()
            self.commonFormat()
            self.filterbanners()
            if self.clone_browser:
                self.clone_banners()
            if self.clone_styles:
                self.clone_banners_with_styles()
            if self.clone_for_country:
                self.clone_banners_country()
            # self.clone_deeplink()
            # if self.clone_with_age_restriction:
            #     self.clone_age()
            self.copyFeatures()
            with open('collections/' + now() + '_' + self.collection, 'w') as fo:
                fo.write(json.dumps(sorted(self.objects, key=lambda o : o.get('internal-url')), indent=4).encode("utf-8"))
            if self.validate:
                self.validate_json()
            self.compare_collection()
            if self.upload:
                self.upload_data()
            self.logger.info("End process classname: {}".format(params["classname"]))


    def encode_url(self, url):
        PROXY_KEY = 'lofoh6oB'
        PROXY_URL = 'https://tapoc.trbo.yandex.net:443/tapoc_secure_proxy/'
        encoded_url = urllib.quote(url.encode("utf-8"))
        hashed_url = hashlib.md5(url.encode("utf-8") + PROXY_KEY).hexdigest()
        return PROXY_URL + hashed_url + '?url=' + encoded_url

    def getSessionid(self):
        self.logger.info("Get Session_id from passport")
        comm = 'curl --data "login=robot-atom-banner&passwd=8VdGRnx*" "https://passport.yandex-team.ru/auth?retpath=https%3A%2F%2Fwiki.yandex-team.ru%2F" 2>/dev/null -c cookies.txt > passport_answer'
        os.system(comm)
        with open("cookies.txt", "r") as f:
            for k in f:
                tabs = k.rstrip().split("\t")
                try:
                    if tabs[5] == "Session_id":
                        self.session_id = tabs[6]
                except:
                    pass
            if len(self.session_id) > 0:
                self.logger.info(
                    "Session_id parsed: {}".format(self.session_id))

    def getUsedBanners(self):
        with open("used_bannerids.tmp", "w") as used_bannerids_tmp_file:
            with open("used_bannerids.txt", "r") as used_bannerids_file:
                for k in used_bannerids_file:
                    tabs = k.rstrip().split("\t")
                    if int(time.time()) - int(tabs[-1]) < 3600 * 24 * 7:
                        self.used_bannerids.add(tabs[0])
                        used_bannerids_tmp_file.write(k)
        os.rename("used_bannerids.tmp", "used_bannerids.txt")

    def downloadData(self):
        self.logger.info('Start download data')
        self.lock.check_lock()
        for place in self.placeid:
            with open('{}.json'.format(place), 'w') as fp:
                args = [
                    '/usr/local/bin/banana-fetch',
                    '-c', 'Session_id={0}'.format(self.session_id),
                    '-r', 'https://yabs.yandex.ru/resource/',
                    '-p', place,
                    '-n', self.hostname
                ]
                if self.excluded_orders:
                    args.extend(['-O', ','.join(map(str, self.excluded_orders))])
                subprocess.call(args=args, stdout=fp)
                self.logger.info(' '.join(args))
        self.lock.free_lock()
        self.logger.info('Download complete')

    def parseContexts(self):
        contexts_counter = 0
        for place in self.placeid:
            with open(place + '_contexts.txt') as contexts:
                for c in contexts:
                    c = c.lstrip().rstrip()
                    if c[0:7] == "PLACEID":
                        context = c.rstrip().split()[-1]
                        self.all_contexts.add(context)
                        self.and_filters[context] = []
                        self.or_filters[context] = []
                        contexts_counter += 1
                        tss = []
                    if "Время московское (число) less" in c:
                        times = int(re.search("([0-9]{10})", c).group(0))
                        if times < int(time.time()):
                            self.bad_contexts.add(context)
                        self.and_filters[context].append("'#ts,lt,{}'".format(times))
                    if "Время московское (число) greater" in c:
                        times = int(re.search("([0-9]{10})", c).group(0))
                        self.and_filters[context].append("'#ts,gt,{}'".format(times))
                    elif ("yandexuid" in c and len(re.findall("yandexuid.*%[0-9]+$", c)) == 0):
                        self.bad_contexts.add(context)
                    elif "ClientIP" in c:
                        self.bad_contexts.add(context)
                    elif "оператор связи equal 2" in c:
                        self.and_filters[context].append(
                            "'#referer,match,nevershow'")
                    elif "clid equal" in c:
                        self.bad_contexts.add(context)
                    if "Пометка о завирусованности equal 1" in c:
                        self.and_filters[context].append("'#virus,eq,1'")

                    '''
                    # supported in banana-fetch (PERSONAL-1442)

                    if "isMobile — мобильное устройство по uatraits equal 1" in c:
                        self.and_filters[context].append(
                            "'#uat:isMobile,eq,true'")
                    elif "isMobile — мобильное устройство по uatraits equal 0" in c:
                        self.and_filters[context].append(
                            "'#uat:isMobile,eq,false'")
                    if "isTablet — планшет по uatraits equal 1" in c:
                        self.and_filters[context].append(
                            "'#uat:isTablet,eq,true'")
                    elif "isTablet — планшет по uatraits equal 1" in c:
                        self.and_filters[context].append(
                            "'#uat:isTablet,eq,true'")
                    if "OS Family — семейство OS по uatraits equal 3'" in c:
                        self.and_filters[context].append(
                            "'#uat:OSFamily,eq,iOS'")
                    elif "OS Family — семейство OS по uatraits equal 2'" in c:
                        self.and_filters[context].append(
                            "('#uat:OSFamily,eq,Android'&'#uat:OSVersion,gt,4.2')"
                        )
                    '''

                    if "Время московское (строка) like _" in c:
                        m = re.search("201[0-9]{5}", c)
                        if m:
                            daryats = int(time.mktime(datetime.datetime.strptime(
                                m.group(0), "%Y%m%d").timetuple()))
                            tss.append(daryats)
                            if daryats > int(time.time()):
                                flt = "('#ts,gt," + str(daryats) + \
                                    "'&'#ts,lt," + str(daryats + 86400) + "')"
                                self.or_filters[context].append(flt)
                    if "Время московское (строка) not like _" in c:
                        m = re.search("201[0-9]{5}", c)
                        if m:
                            daryats = int(time.mktime(datetime.datetime.strptime(
                                m.group(0), "%Y%m%d").timetuple()))
                            tss.append(daryats)
                            flt = "('#ts,lt," + str(daryats) + \
                                "'|'#ts,gt," + str(daryats + 86400) + "')"
                            self.or_filters[context].append(flt)
        self.logger.info("parsed contexts")

    def customFormat(self, k):
        return k

    def copyFeatures(self):
        for k in self.objects:
            for field in self.fields_for_features:
                try:
                    match_field=self.fields_for_features[field]
                    previous_level=k["aux-data"]
                    levels=field.split(".")
                    field_in_aux=True
                    for f in levels:
                        if f in previous_level and "None" not in str(type(previous_level[f])):
                            previous_level=previous_level[f]
                        else:
                            field_in_aux=False
                    if field_in_aux:
                        k[match_field]=previous_level
                except:
                    self.logger.info('exception on {}'.format(k))
                    raise

    def commonFormat(self):
        for place in self.placeid:
            with open('{}.json'.format(place), 'r') as fp:
                data = json.loads(fp.read(), encoding='utf-8')
            data = data[place]
            self.logger.info('len of data is {}'.format(len(data)))
            for k in data:
                if not (
                    str(k["aux-data"]["context_id"]) not in self.bad_contexts and
                    str(k["aux-data"]["context_id"]) in self.all_contexts and
                    (len(self.included_orders) == 0 or len(self.included_orders) > 0 and
                        k["aux-data"]["order_id"] in self.included_orders)
                ):
                    self.logger.info('Filtered: bad_contexts.Lines 342-347 of places/place.py. Desc:{}, Context:{}'.format(
                            k["aux-data"]["_description"].encode('utf-8'),
                            k["aux-data"]["context_id"])
                        )
                    continue

                # ignore test banners:
                if "_test" in k["aux-data"]["_description"]:
                    continue
                if '_bkexp' in k['aux-data']['_description']:
                    continue
                if k["filter"] == "1":
                    k["filter"] = "'#referer,match,nevershow'"
                k = self.customFormat(k)

                if k:
                    try:
                        try:
                            k["url"] = "{}/{}".format(self.hostname, k["__product"])
                        except UnicodeEncodeError:
                            continue
                        k["internal-url"] = '{host}/{prefix}{bannerid}'.format(
                            host=self.hostname, prefix=self.prefix,
                            bannerid=str(k["aux-data"]["banner_id"]))
                        k["aux-data"]["data_ts"] = int(time.time())
                        self.number_of_objects += 1

                        if len(self.and_filters[str(k["aux-data"]["context_id"])]) > 0:
                            self.and_filters[str(k["aux-data"]["context_id"])] = list(
                                set(self.and_filters[str(k["aux-data"]["context_id"])]))
                            if len(k["filter"]) == 0:
                                k["filter"] = "&".join(
                                    self.and_filters[str(k["aux-data"]["context_id"])])
                            else:
                                k["filter"] = k[
                                    "filter"] + "&(" + "&".join(self.and_filters[str(k["aux-data"]["context_id"])]) + ")"
                        if len(self.or_filters[str(k["aux-data"]["context_id"])]) > 0:
                            self.or_filters[str(k["aux-data"]["context_id"])] = list(
                                set(self.or_filters[str(k["aux-data"]["context_id"])]))
                            if len(k["filter"]) == 0:
                                k["filter"] = "(" + "|".join(
                                    self.or_filters[str(k["aux-data"]["context_id"])]) + ")"
                            else:
                                k["filter"] = k["filter"] + "&(" + "|".join(self.or_filters[str(k["aux-data"]["context_id"])]) + ")"
                        key_for_grouping = k["aux-data"]["context_id"]
                        if key_for_grouping not in self.bannerids.keys():
                            self.bannerids[key_for_grouping] = []
                        self.bannerids[key_for_grouping].append([k, 0])
                    except:
                        self.logger.error("problem in {}".format(k))
                        raise

    def collectStat(self):
        r = requests.get('http://atom-admin.n.yandex-team.ru/atom/api/v1/collections/all_keys',
                        headers={'Authorization': 'Token {}'.format(get_token())})
        all_keys_file = json.loads(str(r.text))
        trie = []
        uniq_banners={}
        for key in all_keys_file:
            if isinstance(key, basestring) and key == self.collection:
                trie.append(key)
            elif isinstance(key, dict) and self.collection in key:
                trie.extend(key[self.collection])
        self.logger.info("download stat from {}".format(trie))
        for t in trie:
            self.logger.info("download RTMR stat from {}".format(t))
            r = requests.get('http://rtmr.search.yandex.net:8080/yandsearch?view=plain'
                             '&table=atom/candidate_scores&key={}&maxrecords=1&mrs=100500000'.format(t))
            try:
                rtmr = json.loads(r.text.split("\t")[1])
                for k, v in rtmr.items():
                    if "/" in k and "SUBST" not in k:
                        bid = k.split("/")[1].split("_")[0]
                        if bid not in self.banners_stat.keys():
                            self.banners_stat[bid] = 0
                        rt_stat = v["v"]
                        events = rt_stat.split(" ")
                        for event in events:
                            eventkv = event.split("=")
                            if eventkv[0] == "show_d:4":
                                shows_d4 = int(eventkv[1])+1
                        self.banners_stat[bid] += int(shows_d4)
                break
            except:
                self.logger.warning("no data in RTMR for {}".format(t))

        self.logger.info("get stat from current collection")
        r = requests.get('http://atom-admin.n.yandex-team.ru/atom/api/v1/collections/{}'.format(
            self.collection), headers={'Authorization': 'Token {}'.format(get_token())})

        try:
            for banner in json.loads(r.text):
                if "context_id" in banner["aux-data"]:
                    contextid = banner["aux-data"]["context_id"]
                    if contextid not in self.contexts_banners:
                        self.contexts_banners[contextid] = 0
                    bid = str(banner["internal-url"]).split("/")[1].split("_")[0]
                    if bid in self.banners_stat:
                        self.contexts_banners[
                            contextid] += self.banners_stat[bid]
                        self.total_shows += self.banners_stat[bid]
        except:
            self.logger.warning("no data in switch for {}".format(self.collection))

    def compare_collection(self):
        try:
            r = requests.get('http://atom-admin.n.yandex-team.ru/atom/api/v1/collections/{}'.format(
                self.collection), headers={'Authorization': 'Token {}'.format(get_token())})

            before = {banner['internal-url'].split("/", 1)[-1]: banner['__product'] for banner in json.loads(r.text)}
            after = {banner['internal-url'].split("/", 1)[-1]: banner['__product'] for banner in self.objects}
            common = {banner: after[banner] for banner in after if banner in before}

            diff = "{:20} before:{:4} common:{:4} after:{:4}".format("_total_", len(before), len(common), len(after))

            count_before = Counter(before.values())
            count_after = Counter(after.values())
            count_common = Counter(common.values())
            all_products = sorted(list(set(count_before.keys()) | set(count_common.keys())))

            diff += "\n" + "\n".join(
                "{:20} before:{:4} common:{:4} after:{:4}".format(product, count_before[product], count_common[product],
                                                                  count_after[product]) for product in all_products)
            self.logger.info("Compare collection {} before and after\n{}".format(self.collection, diff))
        except Exception, e:
            self.logger.warning("Unable to compare collections, Exception: {}".format(e))

    def filterbanners(self):
        DIVIDE_BROWSER_MAX_BANNERS = 3
        INCREASE_MAX_BANNERS = 200
        CURRENT_TO_BEST_SHOW_RATIO = 0.7
        CONST_MAX_BANNERS_FROM_CONTEXT = 15

        def fill_stats_for_banner(banner):
            banner_id = banner[0]["internal-url"].split("/")[1].split("_")[0]
            if banner_id in self.banners_stat:
                banner_shows = self.banners_stat[banner_id]
                banner[1] = banner_shows
            else:
                banner[1] = -1
            return banner

        def eval_max_banners_in_context(MAGIC_CONSTANT):
            if self.contexts_banners.get(context_id):
                context_shows = self.contexts_banners[context_id] * MAGIC_CONSTANT
                max_banners_in_context = max(
                    1, round(
                        context_shows / self.total_shows
                    )
                )
            else:
                max_banners_in_context = self.zerogroup_default
                self.contexts_banners[context_id] = 0
            return max_banners_in_context

        def can_reduce_number_of_browser_banners(aux):
            '''
            Intented to reduce number of browsers because they are cloned
            '''
            if all([
                'browser_ru_' in aux['_description'].lower(),
                any(sub in str(aux) for sub in ('browser.yandex.ru',)),
                'download/?lite=1' not in str(aux),
                'nechrome' in aux['_description'].lower(),
                self.placeid != '1127',
                self.clone_browser == 'veil',
            ]):
                return True

        def creative_passes(
            creative_shows,
            max_banners_in_context,
            number_of_banners_from_context,
            top_banner_in_context_shows,
            zerogroup_default,
            zerostat
        ):
            if creative_shows > 0:
                current_creative_shows = math.log(creative_shows)
                best_creative_shows = math.log(top_banner_in_context_shows + 1)
                if all([
                    current_creative_shows / best_creative_shows > CURRENT_TO_BEST_SHOW_RATIO,
                    number_of_banners_from_context < max_banners_in_context,
                    number_of_banners_from_context < CONST_MAX_BANNERS_FROM_CONTEXT
                ]):
                    return True
            elif creative_shows < 0:
                max_possible = max(zerogroup_default, max_banners_in_context)
                if zerostat <= max_possible - number_of_banners_from_context:
                    return True
            else:
                return False

        self.logger.info("Objects before filtering {}".format(self.number_of_objects))

        for context_id, banners in self.bannerids.iteritems():
            zerostat = 0
            shuffle(banners)  # чтобы всё время случайные новые забирать
            for banner in banners:
                banner = fill_stats_for_banner(banner)
            # Sort by shows
            banners = sorted(banners, key=itemgetter(1), reverse=True)
            max_banners_allowed = eval_max_banners_in_context(
                INCREASE_MAX_BANNERS)
            top_banner_in_context_shows = banners[0][1]
            number_of_banners_from_context = 0
            for banner in banners:
                creative = banner[0]
                creative_shows = banner[1]
                max_banners_in_context = max_banners_allowed
                aux = creative['aux-data']
                if can_reduce_number_of_browser_banners(aux):
                    max_banners_in_context /= DIVIDE_BROWSER_MAX_BANNERS
                if creative_shows <= 0:
                    zerostat += 1
                if creative_passes(
                    creative_shows=creative_shows,
                    max_banners_in_context=max_banners_in_context,
                    number_of_banners_from_context=number_of_banners_from_context,
                    top_banner_in_context_shows=top_banner_in_context_shows,
                    zerogroup_default=self.zerogroup_default,
                    zerostat=zerostat
                ) or 'amigo' in aux["_description"].lower() \
                or 'health' in aux['_description'] \
                or 'nevershow' in creative.get('filter'):
                    if creative:
                        self.objects.append(creative)
                    verdict = "PASS"
                    if creative_shows != -1:
                        number_of_banners_from_context += 1
                else:
                    verdict = "FAIL"
                if self.verbose:
                    self.logger.info(tabulate(
                        verdict,
                        context_id,
                        creative["internal-url"],
                        aux["_description"],
                        creative_shows,
                        top_banner_in_context_shows,
                        creative["internal-url"] not in self.used_bannerids,
                        max_banners_in_context,
                        number_of_banners_from_context,
                        zerostat,
                        self.zerogroup_default,
                        number_of_banners_from_context
                    ))

        self.logger.info("Objects after filtering {}".format(len(self.objects)))

    def clone_banners_with_styles(self):
        for creative in self.objects:
            if self.classname in ['Smart_banner']:
                clone_list = self.duplicateStyles(k=creative)
                if len(clone_list) > 0:
                    for clone in clone_list:
                        self.clones_with_styles.append(clone)
                        self.logger.info('Clone styles:' + clone['internal-url'] + ' | ' + clone['aux-data']['_description'])
                    self.logger.info('Removing:' + creative['internal-url'] + ' | ' + creative['aux-data']['_description'])
                    self.originals_to_remove_after_duplicating_styles.append(creative)
        self.objects = [creative for creative in self.objects if creative not in self.originals_to_remove_after_duplicating_styles]
        self.objects += self.clones_with_styles

    def regions_subst_from_description(self, desc):
        '''
        Input:  aux-data._description
        Output:
        [
            {'filter': "'#lr,eq,225'", 'data': 'ru'},
            {'filter': "'#lr,eq,187'", 'data': 'ua'},
            ...
        ]
        '''
        regions_subst = []
        lr_country = {'225': 'ru', '187': 'ua', '149': 'by', '159': 'kz'}
        desc = desc.strip().split('_')
        lrs = [i.split('lr')[1] for i in desc if i.startswith('lr')]
        for lr in lrs:
            if lr_country.get(lr):
                subst = {
                    "filter": "'#lr,eq,{lr}'".format(lr=lr)
                    .replace("'#lr,eq,225'", "('#lr,eq,977'|'#lr,eq,225')"),
                    "data": "{}".format(lr_country[lr])
                }
                regions_subst.append(subst)
        return regions_subst

    def make_common_text_subst(self):
        def make_single_subst(_filter, _data):
            return {'filter': _filter, 'data': _data}

        text_subst = {
            'position': [make_single_subst('default', '')],
            'install_text': [make_single_subst('default',
                                               self.install_text_default)],
            'guide_image': [make_single_subst('default', '')]
        }
        for _filter, position, install_text, guide_image in (
            (
                "'#uat:BrowserName,eq,Chrome'",
                'left-bottom',
                self.install_text_ch,
                False
            ),
            (
                "'#uat:BrowserName,eq,Edge'",
                'center-bottom',
                self.install_text_ie,
                False
            ),
            (
                "'#uat:BrowserName,eq,MSIE'",
                'center-bottom',
                self.install_text_ie,
                False
            ),
            (
                "'#uat:BrowserName,eq,Firefox'",
                'right-top',
                self.install_text_ff,
                self.mask.format('15230/8b832e8e-5ce2-435c-ab15-299973513b9c')
            ),
            (
                "'#uat:BrowserName,eq,Opera'",
                'right-top',
                self.install_text_opr,
                self.mask.format('15207/4337a6df-f7a6-45fd-89fd-df8c142e7dbe')
            ),
        ):
            text_subst['position'].append(
                make_single_subst(
                    '&'.join([_filter, "'#uat:OSName,eq,Windows XP'"]),
                    position))
            text_subst['position'].append(
                make_single_subst(
                    '&'.join([_filter, "'#uat:OSName,not_eq,Windows XP'"]),
                    position))
            text_subst['install_text'].append(
                make_single_subst(_filter, install_text)
            )
            if guide_image:
                text_subst['guide_image'].append({'filter': _filter,
                                                  'data': guide_image})
        return text_subst

    def clone_deeplink(self):
        if not self.classname == 'Smart_banner':
            return
        clone_count = 0
        for xi, creative in enumerate(self.objects):
            if creative['__product'] != 'browser':
                continue
            clone_count += 1
            if self.clone_with_deeplink(creative):
                self.objects[xi] = self.clone_with_deeplink(creative)
        self.logger.info('Deeplenks cloned. Count: {}'.format(clone_count))
        return True

    def clone_banners(self):
        if not self.clone_browser == 'veil':
            return
        clone_original_count = 0
        clone_count = 0
        clone_ctrl_count = 0
        for creative in self.objects:
            if creative['__product'] not in ('browser', 'searchline'):
                continue
            if creative['__product'] != 'searchline':
                if '_lr' not in creative['aux-data']['_description']:
                    continue
            if 'winxp' in creative['aux-data']['_description'].lower():
                continue
            if any(lang in creative['aux-data']['_description']
                   for lang in ('_uk_', '_kz_', '_kk_', '_by_', '_be_')):
                continue
            if any([
                'test' in creative['aux-data']['_description'].lower(),
                'nevershow' in creative['filter']
            ]):
                continue
            if self.classname in ['Teaser'] and '%clid=' in creative['filter']:
                continue
            clone_original_count += 1
            if self.classname in [
                'Portal_popup', 'Teaser',
                'Wizard', 'Stripe',
                'Daas_stripe'
            ]:
                param = self.regions_subst_from_description(
                    creative['aux-data']['_description'])
                clone = self.clone_with_veil(k=creative, param=param)
                if clone:
                    self.logger.info(' '.join([
                        'Clone with veil:',
                        creative['internal-url'],
                        '|', creative['aux-data']['_description']
                    ]))
                    self.clones.append(clone)
                    clone_count += 1

                if self.classname not in ['Daas_stripe']:
                    clone_ctrl = self.clone_with_veil_control(k=creative,
                                                              param=param)
                    if clone_ctrl:
                        self.logger.info(' '.join([
                            'Clone veil ctrl:', creative['internal-url'],
                            '|', creative['aux-data']['_description']]))
                        self.clones.append(clone_ctrl)
                        clone_ctrl_count += 1
            self.logger.info(' '.join(['Removing:', creative['internal-url'], '|',
                                       creative['aux-data']['_description']]))
            self.originals_to_remove_after_cloning.append(creative)

        self.objects = [
            creative for creative in self.objects
            if creative not in self.originals_to_remove_after_cloning
        ]
        self.originals_to_remove_after_cloning = []
        self.clones = filter(None, self.clones)
        self.objects += self.clones
        self.logger.info("Clone veil orig count: {}".format(clone_original_count))
        self.logger.info("Clone veil count: {}".format(clone_count))
        self.logger.info("Clone veil control count: {}".format(
            clone_ctrl_count))
        self.logger.info("number of object after veil cloning: {}".format(
            len(self.objects)))

    def clone_age(self):
        """Temporary fix lack of age restriction (0+) in serp popup"""
        assert self.classname == 'Portal_popup'
        for creative in self.objects:
            age_subst = [
                {
                    'filter': "'#referer,ic_match,%yandex.ru/search/%'",
                    'data': ' (0+)'
                },
                {
                    'filter': 'default',
                    'data': ''
                }
            ]
            creative['text-subst'] = creative.get('text-subst') or {}
            creative['text-subst']['age'] = age_subst

            aux = creative['aux-data']
            aux['subst-fields'] = aux.get('subst-fields') or []
            aux['subst-fields'].append('text')
            aux['text'] = ''.join([aux['text'], '${age}'])
            creative['aux-data'] = aux

    def clone_banners_country(self):
        clones_count = 0
        has_ext_subst = ['Portal_popup', 'Teaser', 'Wizard']
        mobile_places = ['Smart_banner']
        if self.classname in has_ext_subst:
            for creative in self.objects:
                product = creative.get('__product')
                if product not in ('home', 'set', 'sethome'):
                    continue
                if creative['aux-data']['type'] != 'inline':
                    continue
                if "('#lr,eq,977'|'#lr,eq,225')" not in creative['filter']:
                    continue
                if any([
                    'test' in creative['aux-data']['_description'].lower(),
                    'nevershow' in creative['filter']
                ]):
                    continue
                clones_count += 1
                clone = self.clone_ext(creative)
                self.objects.append(clone)
                self.originals_to_remove_after_cloning.append(creative)
                self.logger.info('\t'.join([
                    'Country clone extension: ',
                    creative['aux-data']['_description'],
                    '-->',
                    clone['aux-data']['_description'],
                    clone['internal-url'].split('/')[1],
                ]))
        elif self.classname in mobile_places:
            for creative in self.objects:
                if '_lr' not in creative['aux-data']['_description']:
                    continue
                product = creative.get('__product')
                if product in ('browser', 'search'):
                    clone = self.clone_country(creative)
                    if not clone:
                        continue
                    clones_count += 1
                    self.objects.append(clone)
                    self.originals_to_remove_after_cloning.append(creative)
                    self.logger.info('\t'.join([
                        'Country clone mobile bro: ',
                        creative['aux-data']['_description'],
                        '-->',
                        clone['aux-data']['_description'],
                        clone['internal-url'].split('/')[1],
                    ]))
        self.objects = [creative for creative in self.objects if creative
                        not in self.originals_to_remove_after_cloning]
        self.originals_to_remove_after_cloning = []
        self.logger.info('Country clones: {}'.format(clones_count))
        self.logger.info('Objects count after country clone: {}'.format(
            len(self.objects)))

    def upload_data(self):
        self.logger.info("Upload to switch")
        r = requests.put(
            'http://atom-admin.n.yandex-team.ru/atom/api/v1/collections/{}'.
            format(self.collection),
            data=json.dumps(self.objects, indent=4).encode("utf-8"),
            headers={'Authorization': 'Token {}'.format(get_token())}
        )
        self.logger.info('Upload result: {}'.format(r.text))
