#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import re
import requests

from copy import deepcopy
from jsonschema import validate, exceptions
from place import Place


class Portal_popup(Place):
    def customFormat(self, k):
        self.fields_for_features.update({
            "img_png": "image",
            "color": "background",
            "button_no": "no",
            "button_yes": "yes",
            "install_text": "veiltext",
            "veil": "veil",
            "link": "link",
            "text": "title"
        })
        aux = k['aux-data']
        _description = aux.get("_description") or ""
        if '_serp' not in _description:
            return
        if any(
            mobile_identifier in aux['_description'].lower()
            for mobile_identifier in ('android', 'ipad', 'ios', 'searchapp')
        ):
            k["bandits-weight-expression"] = "(1+EVENT_AD_INSTALL+install)"
            k["fml-weight-expression"] = "MOBLTV"
        else:
            k["bandits-weight-expression"] = "(1+SOFT_EXPORT_EVENT_install)"
            k["fml-weight-expression"] = "LTV"
        if "bandits-weight" in k:
            k.pop("bandits-weight", None)
        k.pop("bandits-weight", None)
        product_parsed_from_description = _description.split("_")[0].lower()
        k["__product"] = aux.get("product") or ""
        k['__product'] = k['__product'] or product_parsed_from_description
        if k["__product"] in ["searchapp", "appsearch"]:
            k["__product"] = "search"
        k["grouping-key"] = "distribution"
        k["snippet"] = ""
        if not aux.get("text"):
            return
        k["title"] = aux["text"]
        aux["layout"] = 'flat'
        aux["link"] = aux.pop('url')
        if not aux["link"]:
            return
        if "chrome.google.com" not in aux["link"]:
            aux["_link_extensions"] = {"link": self.linkextension}
        icon = aux.get('icon')
        if icon:
            aux["image_png"] = aux["icon_png"] = aux["image"] = icon
        icon_svg = aux.get('icon_svg')
        if icon_svg:
            aux["image_svg"] = icon_svg

        is_appsflyer = "appsflyer" in aux['link']
        is_appmetrica = 'appmetrica' in aux['link']
        if not (is_appsflyer or is_appmetrica):
            if "browser" in aux["_description"]:
                aux["_link_extensions"] = {
                    "link": self.linkextension
                }
        elif is_appsflyer or is_appmetrica:
            linkextensions = {
                "af_sub5": "uid",
                "atom_bannerid": "$banner_id",
                "atom_reqid": "reqid",
                "banerid": "showid",
                "host": "$host",
                "yandexuid": "uid",
            }
            aux["_link_extensions"] = {"link": linkextensions}
            if aux.get("icon"):
                aux["image_png"] = aux.pop("icon")
            if aux.get("icon_svg"):
                aux["image_svg"] = aux.pop("icon_svg")
            aux["platform"] = aux["_description"].split("_")[-2]
            aux['type'] = 'landing'
        if "&banerid=" in aux["link"]:
            aux["link"] = re.sub("&banerid=[0-9]+", "", aux["link"])
        allowed_aux_keys = [
            "_link_extensions",
            "_description",
            "age_restriction",
            "animation",
            "banner_id",
            "button_no",
            "button_yes",
            "color",
            "context_id",
            "guide_image",
            "icon",
            "icon_png",
            "icon_svg",
            "image",
            "image_png",
            "image_svg",
            "install_text",
            "layout",
            "legal",
            "link",
            "location",
            "product",
            "platform",
            "position",
            "text",
            "type",
            "veil",
        ]
        aux = {
            key: value
            for key, value
            in aux.iteritems()
            if key in allowed_aux_keys #and value is not None
        }
        k['aux-data'] = aux
        if k["__product"] in self.allowed:
            return k

    def clone_searchline_veil(self, clone, param):
        install_desc = u'<br><br>После этого начнётся установка Яндекс.Строки'
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'",
        ])
        aux = clone['aux-data']
        aux["guide_image"] = self.mask.format(
            '28672/a2731b7b-9fd6-48d2-b4ef-c82ae64f84c1')
        aux['install_text'] = u'Нажмите на стрелку и выберите верхний файл.'
        aux['position'] = 'right-top'
        aux['_link_extensions'] = {"link": {"banerid": "showid"}}
        aux['legal'] = {
            'text': u"Устанавливая Яндекс.Строку, вы принимаете",
            'link': "https://yandex.ru/legal/desktop_software_agreement/",
            'linkText': u" условия лицензионного соглашения"
        }
        aux['type'] = clone['type'] = 'download'
        aux['link'] = clone['link'] = "//yandex.ru/promo/searchline/download/"
        clone['aux-data'] = aux
        return clone

    def clone_with_veil(self, k, param):
        clone = deepcopy(k)
        if clone['__product'] == 'searchline':
            return self.clone_searchline_veil(clone, param)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        clone['text-subst'] = self.make_common_text_subst()
        clone['text-subst']['tld'] = param
        clone['text-subst']['age'] = []

        for filter_data in param:
            age = filter_data['data'].replace('ru', '0+')
            if age != '0+':
                age = ''
            pair = {'filter': filter_data['filter'],
                    'data': age}
            clone['text-subst']['age'].append(pair)

        desc = u'<br><br>После этого начнётся установка Яндекс.Браузера'
        for idx, _ in enumerate(clone['text-subst']['install_text']):
            clone['text-subst']['install_text'][idx]['data'] += desc

        aux = clone["aux-data"]
        aux['subst-fields'] = [
            'age_restriction',
            'guide_image',
            'install_text',
            {'legal': 'link'},
            'link',
            'position',
        ]
        aux["age_restriction"] = "${age}"
        aux["guide_image"] = "${guide_image}"
        aux["install_text"] = "${install_text}"
        aux['link'] = clone['link'] = "//browser.yandex.${tld}/download/"
        aux["legal"] = {
            "link": "https://yandex.${tld}/legal/browser_agreement",
            "linkText": u"условия лицензионного соглашения ",
            "text": u"Устанавливая Яндекс.Браузер, вы принимаете ",
        }
        aux["position"] = '${position}'
        aux["banner_id"] = '_'.join([str(aux["banner_id"]).split("_")[0],
                                     'subst'])
        aux["_link_extensions"] = {"link": {"banerid": "showid"}}
        aux["type"] = "download"
        clone["internal-url"] = "{}/{}{}".format(
            self.hostname, self.prefix, aux["banner_id"])
        clone["aux-data"] = aux
        return clone

    def clone_ext(self, k):
        clone = deepcopy(k)
        aux = clone["aux-data"]
        aux['text'] = aux['text'].replace('.ru', '')
        product = clone.get('__product')
        clone["filter"] = "'#lang,eq,ru'"
        store_link_substs = []
        age_substs = []
        for country in self.clone_country_config:
            subst = {
                'filter': "'#tld,eq,{tld}'".format(tld=country['country']),
                'data': country[product]
            }
            store_link_substs.append(subst)
        for subst in store_link_substs:
            flt = subst.get('filter')
            data = ''
            if 'eq,ru' in subst.get('filter'):
                data = '0+'
            age_substs.append({'filter': flt, 'data': data})
        clone['text-subst'] = {
            "store_link": store_link_substs,
            'age': age_substs
        }
        aux['subst-fields'] = ['link', 'age_restriction']
        aux['age_restriction'] = '${age}'
        aux["link"] = "https://chrome.google.com/webstore/detail/${store_link}"
        aux['_description'] += '_subst'
        clone["aux-data"] = aux
        clone["link"] = aux["link"]
        return clone

    def clone_searchline_veil_control(self, clone, param):
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'"
        ])
        aux = clone['aux-data']
        aux["banner_id"] = '_'.join([str(aux["banner_id"]).split("_")[0],
                                     'ctrl'])
        clone["internal-url"] = "{}/{}{}".format(self.hostname, self.prefix,
                                                 aux["banner_id"])
        clone['aux-data'] = aux
        return clone

    def clone_with_veil_control(self, k, param):
        clone = deepcopy(k)
        if clone['__product'] == 'searchline':
            return self.clone_searchline_veil_control(clone, param)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        clone['text-subst'] = {
            'tld': param,
            "browser": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": "chrome"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": "edge"
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": "msie"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "ff"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "opera"
                },
            ]
        }
        clone['text-subst']['age'] = []
        for filter_data in param:
            age = filter_data['data'].replace('ru', '0+')
            if age != '0+':
                age = ''
            pair = {'filter': filter_data['filter'],
                    'data': age}
            clone['text-subst']['age'].append(pair)

        aux = clone["aux-data"]
        aux['subst-fields'] = ['age_restriction', 'link', '_description']
        aux["banner_id"] = '_'.join([
            str(aux["banner_id"]).split("_")[0],
            'subst_landing'
        ])
        aux['age_restriction'] = '${age}'
        aux["link"] = aux["link"].replace('yandex.ru', 'yandex.${tld}')
        aux['_description'] += '_${browser}'
        clone["internal-url"] = "{}/{}{}".format(
            self.hostname, self.prefix, aux["banner_id"])
        clone["aux-data"] = aux
        clone["link"] = aux["link"]
        return clone

    def validate_json(self):
        valid = []
        # Following variables are used for validation with jsonschema
        self.github_host = 'https://github.yandex-team.ru/raw'
        self.schema_path = 'serp/web4/dev/schema/distribution/distr-popup.json'
        self.schema_url = '{}/{}'.format(self.github_host, self.schema_path)

        self.schema = json.loads(requests.get(self.schema_url).content)
        self.schema = self.schema['properties']['docs']['items']['properties']['source-aux']
        self.schema['required'].remove('counters')

        # validation by jsonschema
        for k in self.objects:
            aux = k.get('aux-data', {})
            if not aux:
                return
            try:
                validate(aux, self.schema)
                valid.append(k)
            except exceptions.ValidationError as e:
                self.logger.warning(e)
                return
        self.objects = valid


if __name__ == '__main__':
    Portal_popup(**kwargs)

