#!/usr/bin/env python
# -*- coding: utf-8 -*-

from place import Place


class Promofooter(Place):
    def customFormat(self, k):
        self.fields_for_features.update({
            "image": "image",
            "background": "background",
            "extension_link": "link",
        })
        k["fml-weight"] = 1
        k["bandits-weight-expression"] = "LTV*click"
        k["__product"] = k["aux-data"]["product"]
        if k["__product"] in ('searchline'):
            return
        k['aux-data']['inline_height'] = k['aux-data'].pop('inline_hight')
        if 'avatars' not in k["aux-data"]["image"]:
            k["aux-data"]["image"] = "https://yabs.yandex.ru/resource/" + \
                k["aux-data"]["image"]
        k["grouping-key"] = "promofooter-" + k["aux-data"]["product"]
        k["title"] = k["aux-data"]["text"]

        if "browser.yandex" in k["aux-data"]["extension_link"] or \
            "element.yandex" in k["aux-data"]["extension_link"] or \
            "set.yandex" in k["aux-data"]["extension_link"] or \
                "home.yandex" in k["aux-data"]["extension_link"]:
            k["aux-data"]["_link_extensions"] = {
                "extension_link": self.linkextension}
        if '_ru' in k['aux-data'].get('_description', '').lower():
            k['filter'] += "&'#lang,ic_match,ru'"
        return k
