#!/usr/bin/env python
# -*- coding: utf-8 -*-

from place import Place


class Promoliba(Place):
    def customFormat(self, k):

        def age_0_plus_expected(aux):
            ru_in_description = 'RU' in aux.get('_description')
            age_is_missing = '0+' not in aux.get('title') and\
                '0+' not in aux.get('body')
            if ru_in_description and age_is_missing:
                return True

        def age_12_plus_expected(aux):
            afisha_ru_in_description = 'afisha_RU' in aux.get('_description')
            age_is_missing = '+' not in aux.get('title') and\
                '+' not in aux.get('body')
            if afisha_ru_in_description and age_is_missing:
                return True

        def clean_viewnotice(viewNotice):
            try:
                url, params = viewNotice.split('?')
                params = params.replace('%7B', '{').replace('%7D', '}')
                params = [
                    param for param in params.split('&')
                    if not any([curly_bracket in param
                                for curly_bracket in ('{', '}',)])
                ]
                clean = '?'.join([url, '&'.join(params)])
                return clean
            except:
                return viewNotice

        self.fields_for_features.update({
            "promolib_campaign.banner/icon": "image"
        })

        try:
            self.linkextension = {
                "atom_reqid": "reqid",
                "atom_bannerid": "$banner_id",
                "host": "$host",
                "banerid": "showid",
                "yandexuid": "uid"
            }
            aux = k['aux-data']
            k["fml-weight"] = 1
            k["bandits-weight-expression"] = "MOBLTV*(EVENT_AD_INSTALL + install)+1"
            if not aux.get('product'):
                self.logger.error('No product specified in {}'.format(aux))
                return
            aux['product'] = aux['product'].replace('autoru', 'auto')
            aux['product'] = aux['product'].replace('navigator', 'navi')
            k["__product"] = aux["product"]
            # if k["__product"] == "launcher":
            #     return
            if k["__product"] == "survey":
                k["mandatory"] = 1
                k["max-shows"] = 1
                k['filter'] += "&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.yandexnavi%'"
            k["grouping-key"] = k["__product"]

            age = aux.get('age')
            if age is not None and age.endswith('+'):
                aux['title'] = ' '.join([aux['title'], ''.join(['(', age, ')'])])
            elif age_12_plus_expected(aux):
                aux['title'] = ' '.join([aux['title'], '(12+)'])
            elif age_0_plus_expected(aux):
                aux['title'] = ' '.join([aux['title'], '(0+)'])

            aux["promolib_campaign"] = {}
            aux["promolib_campaign"]["banner/@timeout"] = 30
            aux["promolib_campaign"]["banner/@type"] = "text"
            aux["promolib_campaign"]["banner/show_cancel_button"] = 0
            aux["promolib_campaign"]["banner/show_continue_button"] = 0
            aux["promolib_campaign"]["banner/show_on_first_run"] = 1
            aux["promolib_campaign"]["max_exposures"] = 1000
            aux["promolib_campaign"]["priority"] = 0
            aux["promolib_campaign"]["banner/title"] = k['title'] = aux["title"]
            aux["promolib_campaign"]["banner/text"] = k["snippet"] = aux["body"]
            aux['viewNotice'] = clean_viewnotice(aux['viewNotice'])
            aux["promolib_campaign"]["banner/href"] = aux["viewNotice"]
            if "confirm_button_position" in aux:
                aux["promolib_campaign"]["banner/confirm_button_position"] = aux["confirm_button_position"]
            if "call_to_action" in aux.get("addInfo") and aux['addInfo']['call_to_action']:
                aux["promolib_campaign"]["banner/confirm_button_caption"] = aux["addInfo"]["call_to_action"]
            if "call_to_action_url" in aux.get("addInfo") and aux['addInfo']['call_to_action_url']:
                aux["promolib_campaign"]["banner/direct_url"] = aux["addInfo"]["call_to_action_url"]

            if "images" in aux:
                image_url = aux["images"][0][0]
                aux["promolib_campaign"]["banner/icon"] = image_url

            aux["_link_extensions"] = {
                "promolib_campaign": {"banner/href": self.linkextension}
            }
            for conditions in ["show_conditions", "hide_conditions"]:
                if aux[conditions] is not None:
                    for os in aux[conditions]:
                        if aux[conditions][os] is not None:
                            aux["promolib_campaign"][conditions + "/" + os] = aux[conditions][os]
            for key in aux.keys():
                if key not in ["_link_extensions", "promolib_campaign", "context_id", "banner_id","_description"]:
                    aux.pop(key)
            for key in aux["promolib_campaign"].keys():
                if aux["promolib_campaign"][key] is None:
                    aux["promolib_campaign"].pop(key)
            if k["__product"] == "browser_alpha" and "'#uat:OSFamily,eq,Android'" in k.get("filter", ""):
                k["filter"] = k["filter"].replace("'#uat:OSFamily,not_eq,iOS'&", "")
                k["filter"] = k["filter"].replace("&'#uat:isTouch,eq,true'", "")
            if k["__product"] == "search_beta" and "'#uat:OSFamily,eq,Android'" in k.get("filter", ""):
                k["filter"] = k["filter"].replace("'#uat:OSFamily,not_eq,iOS'&", "")
                k["filter"] = k["filter"].replace("&'#uat:isTouch,eq,true'", "")
            personal_1818_lst = {"browser", "search", "launcher", "survey", "browserlite", "drive", 'search_beta', 'browser_alpha'}
            if k["__product"] not in personal_1818_lst:
                k["filter"] += "&'#referer,not_match,ru.yandex.yandexbus%'&'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'"
            if k["__product"] == "drive":
                k["filter"] += "&'#referer,not_match,ru.yandex.yandexbus%'&'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.mobile.transport%'"
            if k["__product"] == "maps":
                k["filter"] += "&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.yandexnavi%'"
            if k["__product"] == "navi":
                k["filter"] += "&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'"
            k["filter"] = k["filter"].replace("#lang,ic_match,ru","#lang,eq,ru")
            if k["__product"] != "browser" and k["__product"] != "search":
                 k["filter"] += "&'#referer,not_match,ru.yandex.translate%'&'#referer,not_match,ru.yandex.mobile.translate%'&'#referer,not_match,ru.yandex.translate%'&'#referer,not_match,ru.yandex.mobile.translate%'"
            if 'notclicked' in aux.get('_description'):
                k['filter'] += "&'#feat:626,eq,0'"
            if "hide_conditions/package_installed" in aux["promolib_campaign"]:
                aux["promolib_campaign"]["banner/href"] = aux["promolib_campaign"]["banner/href"] + \
                 "&google_aid={google_aid}&source_id={app_id}&android_id={android_id}&campaign_id={campaign_id}"
            elif "hide_conditions/schema_defined" in aux["promolib_campaign"]:
                aux["promolib_campaign"]["banner/href"] = aux["promolib_campaign"]["banner/href"] + \
                "&source_id={app_id}&ios_ifa={ifa}&campaign_id={campaign_id}"
            else:
                self.logger.info("unexpected platform %s filter: %s" % (aux["banner_id"], str(k["filter"]).lower()))
            k['aux-data'] = aux
            return k
        except Exception as e:
            pass
            # self.logger.info(k["aux-data"].get("_description"), e)
