#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import json
import requests

BANNERS = []
COUNTER = 0
MAX_RETRIES = 5
EXPORT = 'http://portal-export.yandex.net/pusher_exports/wrk/examples_66.json'

r = requests.get(EXPORT)

retries = 0
while r.status_code != requests.codes.ok and retries <= MAX_RETRIES:
    r = requests.get(EXPORT)
    retries += 1

morda_data = [{'text': i['text'], 'rubric': i['rubric']}
              for i in r.json()['data']]

for creative in morda_data:
    text = creative['text']
    rubric = creative['rubric']
    COUNTER += 1
    banner = {
        "__product": "promoquery",
        "aux-data": {
            "_atom_lang": "ru",
            "_description": "promoquery_RU_serp_promoquery_",
            "_internal_url": "promoquery/999" + str(COUNTER),
            "banner_id": int('999' + str(COUNTER)),
            "product": "promoquery",
            "search_request": text,
            "theme": "grey"
        },
        "bandits-weight": 1,
        "bandits-weight-expression": "click",
        "filter": "'#lr,eq,225'&'#referer,match,%yandex.ru/search%'&\
'#feat:527,gt,0.994'&'#referer,ic_not_match,%{}%'".format(text.replace(' ', '%20').encode('utf-8')),
        "fml-weight": 1,
        "grouping-key": rubric,
        "ignore-default-filters": 1,
        "internal-url": "promoquery/999" + str(COUNTER),
        "lang": 1,
        "mandatory": 0,
        "scores": [
            "0/0/0",
            "0/0/0"
        ],
        "title": text,
        "url": "promoquery/promoquery"
    }
    BANNERS.append(banner)

def upload_data(banners):
    with open('vault/.atom_admin_token', 'r') as f:
        token = f.readline().strip()
    r = requests.put(
        'http://atom-admin.n.yandex-team.ru/atom/api/v1/collections/promoquery_import',
        data=json.dumps(banners, indent=4).encode("utf-8"),
        headers={'Authorization': 'Token {}'.format(token)}
    )
    print 'Upload promoquery: SUCCESS'

upload_data(BANNERS)

