#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import copy
import os.path
import sys
import re

from place import Place
from common import check_regions

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))
from parser_filters import pack
from delete_defaults_filters import delete_defaults


class Smart_banner(Place):
    def clear_strong_tags(self, snippet):
        return snippet.replace("<strong>", "").replace("</strong>", "")

    def isMatchTtxNewDesign(self, k, ):
        title = k.get("title", "")
        snippet = k.get("snippet", "")
        if not 0 < len(title) <= 22:
            self.logger.info(' | '.join(['TTX not match len for title',
                                         k['aux-data']['_description']]))
            return False
        if not 0 < len(snippet) <= 26:
            self.logger.info(' | '.join(['TTX not match len for snippet',
                                         k['aux-data']['_description']]))
            return False
        return True

    def isMatchTtx(self, k):
        snippet = k.get("snippet", "")
        dbg_tmpl = '{} | Snippet: {} | _description: {}'
        if not len(snippet):
            self.logger.info(' | '.join(['TTX not match: no snippet',
                                         k['aux-data']['_description']]))
            return False
        if "<strong>" not in snippet:
            self.logger.info(dbg_tmpl.format(
                'TTX not match: no <strong> tag in snippet',
                snippet,
                k['aux-data']['_description']
            ))
            return False
        if len(self.clear_strong_tags(snippet)) > 60:
            self.logger.info(dbg_tmpl.format(
                'TTX not match: snippet too long',
                snippet, k['aux-data']['_description']
            ))
            return False
        return True

    def duplicateStyles(self, k):
        styles = [
            {
                "styles": {
                    "button_no": {
                        "color": "#000"
                    },
                    "button_yes": {
                        "background": "#2A9C2A",
                        "color": "#fff"
                    },
                    "buttons": {
                        "font-size": "17px",
                        "font-weight": "normal",
                        "letter-spacing": "normal",
                        "text-transform": "none"
                    }
                }
            },
            {
                "styles": {
                    "button_no": {
                        "color": "#000"
                    },
                    "button_yes": {
                        "background": "#F52525",
                        "color": "#fff"
                    },
                    "buttons": {
                        "font-size": "17px",
                        "font-weight": "normal",
                        "letter-spacing": "normal",
                        "text-transform": "none"
                    }
                }
            },
            {
                "styles": {
                    "button_no": {
                        "color": "#000"
                    },
                    "button_yes": {
                        "background": "#0044BB",
                        "color": "#fff"
                    },
                    "buttons": {
                        "font-size": "17px",
                        "font-weight": "normal",
                        "letter-spacing": "normal",
                        "text-transform": "none"
                    }
                }
            },
            {
                "styles": {
                    "button_no": {
                        "color": "#000"
                    },
                    "button_yes": {
                        "background": "#4273FF",
                        "color": "#fff"
                    },
                    "buttons": {
                        "font-size": "17px",
                        "font-weight": "normal",
                        "letter-spacing": "normal",
                        "text-transform": "none"
                    }
                }
            },
            {
                "styles": {
                    "button_no": {
                        "color": "#000"
                    },
                    "button_yes": {
                        "background": "#FFCC00",
                        "color": "#000"
                    },
                    "buttons": {
                        "font-size": "17px",
                        "font-weight": "normal",
                        "letter-spacing": "normal",
                        "text-transform": "none"
                    }
                }
            }
        ]
        k_list = []
        style_index = 0
        for style in styles:
            k_out = copy.deepcopy(k)
            k_out["aux-data"]["styles"] = {}
            k_out["aux-data"]["styles"] = copy.deepcopy(style["styles"])
            k_out["internal-url"] = k_out["internal-url"] + "_" + str(style_index)
            k_list.append(copy.deepcopy(k_out))
            style_index += 1
        return k_list

    def handle_age_restriction(self, aux):
        if 'age_restriction' in aux:
            return aux
        region = aux['_description'].split('_')[1].lower()
        pattern = '[0-9][0-9]?\+'
        age_in_snippet = re.search(pattern=pattern, string=aux.get('snippet'))
        if age_in_snippet:
            aux['snippet'] = re.sub(pattern.join(['\(', '\)']), '',
                                    aux['snippet']).strip()
            aux['age_restriction'] = age_in_snippet.group()
        elif not age_in_snippet and region == 'ru':
            aux['age_restriction'] = '0+'
        else:
            aux['age_restriction'] = ''
        return aux


    def handle_null_features(self, aux):
    	new_features = []
    	features = aux.get('features')
    	if not features:
    	    return aux
    	for feat in features:
    	    if all(feat.values()):
    	        new_features.append(feat)
    	aux.pop('features', None)
    	if new_features:
    	    aux['features'] = new_features
        else:
            aux.pop('styles', None)
    	return aux

    def customFormat(self, k):
        def clean_link(link):
            try:
                url, params = link.split('?')
                params = params.replace('%7B', '{').replace('%7D', '}')
                params = [
                    param for param in params.split('&')
                    if not any([curly_bracket in param
                                for curly_bracket in ('{', '}',)])
                ]
                clean = '?'.join([url, '&'.join(params)])
                return clean
            except:
                return link

        self.fields_for_features.update({
            "image": "image",
            "link": "link",
            "button_yes": "yes",
            "button_no": "no",
        })
        self.linkextension = {
            "af_sub5": "uid",
            "atom_reqid": "reqid",
            "atom_bannerid": "$banner_id",
            "banerid": "showid",
            "host": "$host",
            "yandexuid": "uid",
        }
        self.allowed_products = {
            'browser',
            'browserupdate',
            'launcher',
            'search',
            'browserlite',
            'navi',
            'orion',   # personal--1849
            'orion-navigation',
            # 'maps',
            # 'taxi'
        }
        k["fml-weight"] = 1.0
        k["bandits-weight-expression"] = "(10*EVENT_AD_INSTALL + 10*install + real_click) + 1"
        k["fml-weight-expression"] = "MOBLTV"
        aux = k["aux-data"]
        aux = self.handle_null_features(aux)
        try:
            aux = self.handle_age_restriction(aux)
        except Exception as e:
            self.logger.info(e)
            self.logger.info('problem with ' + str(aux['banner_id']))
            return
        aux['design_version'] = "2"
        k['age_restriction'] = aux['age_restriction']
        aux["_link_extensions"] = {"link": self.linkextension}
        if aux.get('image'):
            aux['image'] = aux['image'].replace('.gif/optimize', '.gif/orig')
        if 'browserupdate' in aux["_description"]:
            aux["product"] = 'browserupdate'
            k["fml-weight-expression"] = "10*MOBLTV"
        aux['link'] = clean_link(aux['link'])
        aux["link"] = re.sub("&banner_id=[^$&]+", "", aux.get("link", '') or "")
        k["grouping-key"] = k["__product"] = aux["product"]
        k["snippet"] = aux.get('snippet', '')
        k["title"] = aux["title"]
        snippet_type = aux.get('styles', {}).get('type', '')
        if snippet_type != 'features':
            aux['snippet'] = k["snippet"] = "<strong>{}</strong> {}".format(
                k["title"], k["snippet"])
        platform_target = ''
        if not aux.get('platform'):
            return
        if aux["platform"].lower() == "ios":
            k["fml-weight"] = 0.6
            platform_target = "&'#uat:OSFamily,eq,iOS'"
        elif aux["platform"].lower() == "android":
            platform_target = "&'#uat:OSFamily,eq,Android'"
        if 'news' in aux['_description'] and not aux.get('background_color'):
            aux['background_color'] = "#f3f1ed"
        aux["link"] = re.sub('&[^&=]+={[^&=]+}', '', k["aux-data"]["link"])
        allowed_aux_keys = [
            '_atom_lang',
            '_atom_url',
            '_description',
            '_internal_url',
            '_link_extensions',
            'age_restriction',
            'background_color',
            'banner_id',
            'button_no',
            'button_yes',
            'context_id',
            'data_ts',
            'design_version',
            'features',
            'image',
            'link',
            'name',
            'order_id',
            'platform',
            'product',
            'snippet',
            'styles',
            'title',
        ]
        aux = {
            key: value
            for key, value
            in aux.iteritems()
            if key in allowed_aux_keys
        }
        if k["__product"] not in self.allowed_products:
            return

        k['aux-data'] = aux
        k['filter'] = pack(delete_defaults(k['filter']))
        if platform_target:
            k['filter'] += platform_target
        if check_regions(k, ['ru', 'by']) and not aux['age_restriction']:
            self.logger.info('remove bannerid={}, bad age restriction. description={}'.format(aux['banner_id'], aux['_description']))
            return
        if snippet_type == 'features':
            if self.isMatchTtxNewDesign(k):
                return k
        elif self.isMatchTtx(k):
            return k

    def clone_with_deeplink(self, creative):
        clone = copy.deepcopy(creative)
        aux = clone['aux-data']
        if aux['platform'] != 'android':
            return
        deeplink = 'https://redirect.appmetrica.yandex.com/serve/385387752440558002?c=Smart_serp&adgroup=old&creative=old&source_id=serp'
        deeplink_filter = "&".join([
            # "'#uat:OSFamily,eq,Android'",
            "('#uat:OSVersion,gt,5.0'&'#uat:OSVersion,lt,7.0')",
            "({})".format("|".join([
                "'#uat:BrowserName,eq,{}'".format(bro)
                for bro in ('ChromeMobile', 'OperaMobile', 'OperaMini',
                            'UCBrowser', 'MobileFirefox', 'AndroidBrowser')
            ])),
        ])
        if not clone.get('text-subst'):
            clone['text-subst'] = {
                'link': [
                    {
                        'filter': deeplink_filter,
                        'data': deeplink
                    },
                    {
                        'filter': 'default',
                        'data': aux['link']
                    }
                ]
            }
        elif creative.get('text-subst'):
            aux['subst-fields'] = ['link']
            clone['text-subst']['link'].insert(0, {
                'filter': '&'.join([
                    creative['text-subst']['link'][0]['filter'],
                    deeplink_filter]),
                'data': deeplink
            })
        aux['subst-fields'] = ['link']
        aux['link'] = clone['link'] = '${link}'
        clone['aux-data'] = aux
        return clone

    def clone_country(self, creative):
        lr_tld = {'225': 'ru', '187': 'ua', '149': 'by', '159': 'kz'}
        links_dict = {}


        c_prefix_substs = []
        clone = copy.deepcopy(creative)
        aux = clone["aux-data"]
        _filter = clone['filter']
        if '#lr,eq,225' not in _filter:
            return
        if 'yandex.ru' not in _filter:
            return
        if 'appsflyer' not in aux['link']:
            return

        def lrs_from_description(desc):
            desc = desc.strip().split('_')
            lrs = [i.split('lr')[1] for i in desc if i.startswith('lr')]
            return lrs

        def add_c_prefix(prefix, link):
            if '&c=RU' not in link:
                link = link.split('&c=')
            else:
                link = link.split('&c=RU_')
            return '&c={}'.format(prefix).join(link)

        def make_subst(_filter, lr, link):
            link = add_c_prefix('{}', link)
            country_lr = "'#lr,eq,{}'".format(lr)
            if lr != '225':
                flt = _filter\
                    .replace('yandex.ru', 'yandex.{}'.format(lr_tld[lr]))\
                    .replace("'#lr,eq,977'|'#lr,eq,225'", country_lr)\
                    .replace("'#lr,eq,225'", country_lr)\
                    .replace("'#lr,eq,977'", country_lr)
            elif lr == '225':
                flt = _filter
            data = '{}_'.format(lr_tld[lr].upper()).replace('RU_', '')
            if flt.startswith('&'):
                flt = flt[1:]
            return {
                'filter': flt,
                'data': link.format(data)
            }

        def subst_age(lr):
            if lr == '225':
                return {'filter': "('#lr,eq,977'|'#lr,eq,225')",
                        'data': aux.get('age_restriction')}
            else:
                return {'filter': "'#lr,eq,{}'".format(lr), 'data': ''}

        aux['title'] = aux['title'].replace('.ru', '').replace('0+', '')
        aux['snippet'] = aux['snippet'].replace('.ru', '').replace('0+', '')
        c_prefix_substs = [
            make_subst(_filter, lr, aux['link']) for lr in
            lrs_from_description(aux['_description'])
        ]

        clone['text-subst'] = {'link': c_prefix_substs}
        clone['text-subst']['age_restriction'] = []
        for lr in lrs_from_description(aux['_description']):
            clone['text-subst']['age_restriction'].append(subst_age(lr))
        aux['subst-fields'] = ['link', 'age_restriction']
        aux['link'] = clone['link'] = '${link}'
        aux['age_restriction'] = '${age_restriction}'
        aux['_description'] += '_subst'
        clone['aux-data'] = aux
        clone['filter'] = ''
        return clone
