#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
from copy import deepcopy

from place import Place
from common import check_regions, remove_params_with_curly_brackets

class Softlink(Place):
    def parse_product_from_desc(self, desc):
        product = desc.split("_")[0].lower()
        return product

    def customFormat(self, k):
        self.fields_for_features.update({
            "img.url": "image",
            "type": "type",
            "text1": "title",
            "install_text": "veil_text"
        })
        aux = k['aux-data']
        if not aux:
            return
        if not aux.get('text1'):
            return
        if not aux.get('img', {}).get('url'):
            return

        if "url" in aux:
            aux["url"] = remove_params_with_curly_brackets(aux["url"])
        _description = aux.get("_description") or ""
        if any(
            mobile_identifier in aux['_description'].lower()
            for mobile_identifier in ('android', 'ipad', 'ios', 'searchapp')
        ):
            k["bandits-weight-expression"] = "(1+EVENT_AD_INSTALL+install)"
            k["fml-weight-expression"] = "MOBLTV"
        else:
            k["bandits-weight-expression"] = "(1+SOFT_EXPORT_EVENT_install)"
            k["fml-weight-expression"] = "LTV"
        if "bandits-weight" in k:
            k.pop("bandits-weight", None)
        k["__product"] = self.parse_product_from_desc(_description)
        k["grouping-key"] = 'softlink'
        if aux.get('url') and "chrome.google.com" not in aux.get("url"):
            aux["_link_extensions"] = {"url": self.linkextension}
        else:
            aux["type"] = "inline"
            aux["inline_url"] = aux.pop("url")
            if k["__product"] == "set":
                aux["fadeText"] = u"Нажмите 'Установить расширение',\
 чтобы Яндекс стал вашим поиском по умолчанию."
            elif k["__product"] == "vb":
                aux["fadeText"] = u"Нажмите 'Установить расширение',\
 чтобы установить визуальные закладки яндекса."
            elif k["__product"] == "home":
                aux["fadeText"] = u"Нажмите 'Установить расширение',\
 чтобы сделать Яндекс домашней страницей."
            else:
                aux["fadeText"] = u"Нажмите 'Установить расширение'"
            aux["fadePadding"] = "420"
            aux["fadeTheme"] = "black"
            aux["fadeAgreement"] = u"Устанавливая расширение, \
вы принимаете условия лицензионного соглашения \
https://yandex.ru/legal/desktop_software_agreement/"

        if "url" in aux and "&banerid=" in aux["url"]:
            aux["url"] = re.sub("&banerid=[0-9]+", "", aux["url"])
        allowed_auxdata_keys = [
            "_description",
            "_link_extensions",
            "banner_id",
            "context_id",
            "fadeAgreement",
            "fadePadding",
            "fadeText",
            "fadeTheme",
            "img",
            "inline_url",
            "install_text",
            "legal",
            "position",
            "text1",
            "text2",
            "type",
            "url",
        ]
        aux = {
            key: value
            for key, value
            in aux.iteritems()
            if key in allowed_auxdata_keys
        }
        if ('ipad' not in _description) and ('android' not in _description):
            return
        k["aux-data"] = aux
        return k

    def clone_searchline_veil(self, clone, param):
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#uat:OSFamily,eq,Windows'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'",
        ])
        aux = clone['aux-data']
        clone["veil_text"] = aux['install_text'] = u'Нажмите на стрелку и \
выберите верхний файл.<br><br>После этого начнётся установка Яндекс.Строки'
        aux["guide_image"] = 'https://avatars.mds.yandex.net/get-serp/28672/\
a2731b7b-9fd6-48d2-b4ef-c82ae64f84c1/orig'
        aux['position'] = 'right-top'
        aux['_link_extensions'] = {"url": {"banerid": "showid"}}
        aux['legal'] = {
            'text': u"Устанавливая Яндекс.Строку, вы принимаете",
            'link': "https://yandex.ru/legal/desktop_software_agreement/",
            'linkText': u" условия лицензионного соглашения"
        }
        aux['type'] = clone['type'] = 'download'
        aux['url'] = clone['link'] = "//yandex.ru/promo/searchline/download/"
        clone['aux-data'] = aux
        return clone

    def clone_with_veil(self, k, param):
        clone = deepcopy(k)
        if clone['__product'] == 'searchline':
            return self.clone_searchline_veil(clone, param)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        clone['text-subst'] = {
            'tld': param,
            "position": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": "left-bottom"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": "center-bottom"
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": "center-bottom"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "right-top"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "right-top"
                },
            ],
            "install_text": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": u'Нажмите кнопку, на которую указывает стрелка.\
<br><br>После этого начнётся установка Яндекс.Браузера'
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": u'Нажмите кнопку «Выполнить» на панели внизу.\
<br><br>После этого начнётся установка Яндекс.Браузера'
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": u'Нажмите кнопку «Выполнить» на панели внизу.\
<br><br>После этого начнётся установка Яндекс.Браузера'
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": u'Нажмите на синюю стрелку и выберите верхний файл.\
<br><br>После этого начнётся установка Яндекс.Браузера'
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": u'Нажмите на стрелку и выберите верхний файл.\
<br><br>После этого начнётся установка Яндекс.Браузера'
                },
            ],
            "guide_image": [
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "https://avatars.mds.yandex.net/get-serp/15230/\
8b832e8e-5ce2-435c-ab15-299973513b9c/orig",
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "https://avatars.mds.yandex.net/get-serp/15207/\
4337a6df-f7a6-45fd-89fd-df8c142e7dbe/orig",
                },
                {
                    "filter": "default",
                    "data": ""
                },
            ],
        }
        aux = clone["aux-data"]
        aux['subst-fields'] = [
            'guide_image',
            'install_text',
            {'legal': 'link'},
            'position',
            'url']
        aux["guide_image"] = "${guide_image}"
        aux["install_text"] = "${install_text}"
        aux["position"] = '${position}'
        aux["_link_extensions"] = {"url": {"banerid": "showid"}}
        aux["url"] = "//browser.yandex.${tld}/download/"
        aux["legal"] = {
            "text": u"Устанавливая Яндекс.Браузер, вы принимаете",
            "linkText": u" условия лицензионного соглашения",
            "link": "https://yandex.${tld}/legal/browser_agreement"}
        aux["type"] = "download"
        clone["aux-data"] = aux
        return clone

    def clone_searchline_veil_control(self, clone, param):
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#uat:OSFamily,eq,Windows'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'"
        ])
        aux = clone['aux-data']
        aux["banner_id"] = '_'.join([str(aux["banner_id"]).split("_")[0],
                                     'ctrl'])
        clone["internal-url"] = "{}/{}{}".format(self.hostname, self.prefix,
                                                 aux["banner_id"])
        clone['aux-data'] = aux
        return clone

    def clone_with_veil_control(self, k, param):
        clone = deepcopy(k)
        if clone['__product'] == 'searchline':
            return self.clone_searchline_veil_control(clone, param)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        clone['text-subst'] = {
            'tld': param,
            "browser": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": "chrome"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": "edge"
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": "msie"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "ff"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "opera"
                },
            ]
        }
        aux = clone["aux-data"]
        aux['subst-fields'] = ['url', '_description']
        aux["banner_id"] = '_'.join([
            str(aux["banner_id"]).split("_")[0],
            'subst_landing'
        ])
        aux["url"] = aux["url"].replace('yandex.ru', 'yandex.${tld}')
        aux['_description'] += '_${browser}'
        clone["internal-url"] = "{}/{}{}".format(
            self.hostname, self.prefix, aux["banner_id"])
        clone["aux-data"] = aux
        return clone

    def clone_ext(self, k):
        clone = deepcopy(k)
        aux = clone["aux-data"]
        aux['text1'] = aux['text1'].replace('.ru', '')
        product = clone.get('__product')
        clone["filter"] = "'#lang,eq,ru'"
        store_link_substs = []
        for country in self.clone_country_config:
            subst = {
                'filter': "'#tld,eq,{tld}'".format(tld=country['country']),
                'data': country[product]
            }
            store_link_substs.append(subst)
        clone['text-subst'] = {
            "store_link": store_link_substs
        }
        aux['subst-fields'] = ['inline_url']
        aux["inline_url"] = "https://chrome.google.com/webstore/detail/${store_link}"
        aux['_description'] += '_subst'
        clone["aux-data"] = aux
        clone["link"] = aux["inline_url"]
        return clone
