#!/usr/bin/env python
# -*- coding: utf-8 -*-

from place import Place
import time
import re
import traceback
from copy import deepcopy


class Stripe(Place):
    def remove_resource_https(self, url):
        if 'resource/https:' in url:
            return url.split('resource/')[1]
        else:
            return url

    def customFormat(self, k):
        self.fields_for_features.update({
            "background_image": "background",
            "text2": "yes",
            "text1_url": "link"
        })
        try:
            aux = k['aux-data']
            aux['background_image'] = self.remove_resource_https(
                aux['background_image']
            )
            k['background'] = aux['background_image']
            aux['background_color_file'] = self.remove_resource_https(
                aux['background_color_file']
            )
            aux['background_color_file2'] = self.remove_resource_https(
                aux['background_color_file']
            )
            if not (("addon_stripe" in aux["_description"]) or
                    ("_main" in aux["_description"]) or
                    ("_serp" in aux["_description"])):
                return
            if any(
                mob_identifier in aux['_description'].lower()
                for mob_identifier in ('android', 'ipad', 'ios', 'searchapp')
            ):
                k["bandits-weight-expression"] = "(1+EVENT_AD_INSTALL+install)"
                k["fml-weight-expression"] = "MOBLTV"
            else:
                k["bandits-weight-expression"] = "(1+SOFT_EXPORT_EVENT_install)"
                k["fml-weight-expression"] = "LTV"
            if "bandits-weight" in k:
                k.pop("bandits-weight", None)
            k.pop("bandits-weight", None)

            if "close_counter" in aux:
                aux["close_counter"] = ""
            k["grouping-key"] = "distribution"
            k["__product"] = aux.get('product', '')
            if not k["__product"]:
                k["__product"] = str(
                    aux["_description"].split("_")[0]
                )
            aux["product_name"] = k["__product"]

            if "addon_stripe" in aux["_description"]:
                return

            if not aux['text1_url'] and aux['text2_url']:
                aux['text1_url'] = aux['text2_url']

            if any(
                x in (aux.get("text1_url") or '') for x in [
                    'yandex.ru/yandex_browser', 'browser.yandex.', 'yandex.com.tr/browser/'
                    'sovetnik.yandex.ru', 'yandex.ru/promo/searchline',
                    'element.yandex', 'set.yandex', 'home.yandex',
                    'yandex.ru/save', 'yandex.ua/save', 'yandex.by/save',
                    'yandex.kz/save', 'yandex.com.tr/save'
                ]
            ):
                aux["_link_extensions"] = {
                    "text1_url": self.linkextension,
                    "text2_url": self.linkextension,
                    "void_url": self.linkextension}
                linknames = ["text1_url", "text2_url", "void_url"]
                for linkname in linknames:
                    if linkname in aux and "&banerid=" in aux[linkname]:
                        aux[linkname] = re.sub("&banerid=[0-9]+", "",
                                               aux[linkname])
            if any(x in (aux.get("text1_url") or '') for x in ["search-bot.yandex.net"]):
                self.linkextension = {"lr": "lr"}
                aux["_link_extensions"] = {
                    "text1_url": self.linkextension,
                    "text2_url": self.linkextension,
                    "void_url": self.linkextension
                }

            if "bottom" in aux["_description"]:
                aux["position_type"] = "bottom"

            if k['__product'] != 'virus':
                k["filter"] = (
                    k["filter"] + "&('#feat:527,gt,0.016'|'#feat:527,eq,0')"
                )

            # Don't show distribution for the SERPs from home example link
            k["filter"] = k["filter"] + \
                "&'#referer,not_match,%example_source%'"

            # temporary changing links for inline
            chromeext = ""
            if "set_RU_serp_chrome_inline" in aux["_description"]:
                chromeext = "laddjijkcfpakbbnnedbhnnciecidncp"
            elif "set_UA_serp_chrome_inline" in aux["_description"]:
                chromeext = "ijbepmfgphlcbokeedcnmbedhckonlin"
            elif "set_BY_serp_chrome_inline" in aux["_description"]:
                chromeext = "bfbfnompmdfinceiocgbokojkolbmphe"
            elif "set_KZ_serp_chrome_inline" in aux["_description"]:
                chromeext = "pbhpmmlgceejicjkjadehdndidlbljdg"
            elif "set_tr_serp_chrome_inline" in aux["_description"]:
                chromeext = "mobcpkhofclbcicgjeghekacknnmgnih"
            elif "home_RU_serp_chrome_inline" in aux["_description"]:
                chromeext = "lalfiodohdgaejjccfgfmmngggpplmhp"
            elif "home_UA_serp_chrome_inline" in aux["_description"]:
                chromeext = "lpedlkoodagolnaladgccadeahpjgblg"
            elif "home_tr_serp_chrome_inline" in aux["_description"]:
                chromeext = "cjicdfbaofbgmfoledldagnfddkhjgcd"
            elif "vb_RU_serp_chrome_inline" in aux["_description"]:
                chromeext = "pchfckkccldkbclgdepkaonamkignanh"
            elif "vb_UA_serp_chrome_inline" in aux["_description"]:
                chromeext = "gbaboimfhjmdflnpkooeinbpigncgbhp"
            if "inline" in aux["_description"] and chromeext != "" and "chrome.google.com" not in aux["text1_url"]:
                aux["text1_url"] = "https://chrome.google.com/webstore/detail/" + chromeext
                aux["text2_url"] = "https://chrome.google.com/webstore/detail/" + chromeext
                aux["void_url"] = "https://chrome.google.com/webstore/detail/" + chromeext

            # Check no typo in set_home in aux-data.name
            _name = str(aux.get('name')) or ''
            aux['name'] = _name.replace('sethome', 'set_home')

            k['aux-data'] = aux
            if k["__product"] in self.allowed and \
                    aux['text1_left'] and \
                    aux['text2_left'] and \
                    aux['background_image_left']:
                return k
        except:
            with open("log.txt", "a") as log:
                log.write("{}\tproblem in {} - {}: {}\n".format(
                    time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime()),
                    self.classname,
                    k["aux-data"]["banner_id"],
                    traceback.format_exc()
                ))

    def clone_with_veil_control(self, k, param):
        k_clone = deepcopy(k)
        k_clone["aux-data"]["banner_id"] = '_'.join([
            str(k_clone["aux-data"]["banner_id"]).split("_")[0],
            param.get('tag'),
            'ctrl'
        ])
        k_clone["filter"] = '&'.join([param['filter'],
                                      "'#referer,match,%yandex.ru/search%'"])
        k_clone["internal-url"] = "{}/{}{}".format(
            self.hostname, self.prefix, k_clone["aux-data"]["banner_id"]
        )
        k_clone["aux-data"]["_internal_url"] = k_clone["internal-url"]
        k_clone["url"] = "{}/{}".format(self.hostname, k_clone["__product"])
        # Mostly for consistency
        if 'chrome' in param.get('tag'):
            k_clone['aux-data']['_description'] = k_clone['aux-data']['_description'].replace('_neChrome_', '_chrome_')
        return k_clone

    def clone_with_veil(self, k, param):
        pass
