#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
from copy import deepcopy
from place import Place
import json

from common import disable_age_check_in_sandbox, get_age_check_in_sandbox


class Teaser(Place):
    def handle_age_restriction(self, aux):
        ar = aux.get('age_restriction') or ''
        description = aux.get('_description')
        is_ru = '_RU_' in description
        if is_ru:
            assert ar, 'age_restriction in ru is {}, description: {}'.format(ar, description)
        if '+' in ar:
            return aux
        elif is_ru:
            aux['age_restriction'] = '0+'
        return aux

    def customFormat(self, k):
        self.fields_for_features.update({
            "img.url": "image",
            "type": "type",
            "url": "link"
        })
        aux = k["aux-data"]
        _description = aux["_description"]
        order_id = aux.get('order_id', -1)
        try:
            if order_id in {18213262}:
                disable_age_check_in_sandbox(k)
            else:
                aux = self.handle_age_restriction(aux)
            k["grouping-key"] = "teaser"
            product = aux.get('product') or str(_description.split("_")[0])
            k["__product"] = aux['product'] = product
            if k['__product'] == 'translate':
                return
            if k["__product"] == "searchline":
                k["filter"] = '&'.join([
                    "('#lr,eq,977'|'#lr,eq,225')",
                    "'#lang,eq,ru'",
                    "'#ua,ic_match,%windows%'",
                    "'#uat:isMobile,eq,false'",
                    "'#uat:BrowserName,eq,YandexBrowser'"
                ])
            if any(
                mobile_identifier in _description.lower()
                for mobile_identifier in ('android', 'ipad', 'ios', 'searchapp')
            ):
                k["bandits-weight-expression"] = "(1+EVENT_AD_INSTALL+install)"
                k["fml-weight-expression"] = "MOBLTV"
            else:
                k["bandits-weight-expression"] = "(1+SOFT_EXPORT_EVENT_install)"
                k["fml-weight-expression"] = "LTV"
            if "bandits-weight" in k:
                k.pop("bandits-weight", None)
            aux["host"] = "teaser"
            if aux["url"] and any(
                x in aux["url"]
                for x in ["browser.yandex", "element.yandex", "set.yandex",
                          "home.yandex", "yandex.ru/yandex_browser",
                          "yandex.ru/promo/searchline", "set/lp/"]
            ):
                aux["_link_extensions"] = {"url": self.linkextension}
                aux["type"] = "landing"
                if aux.get('url') and "&banerid=" in aux["url"]:
                    aux["url"] = re.sub("&banerid=[0-9]+",
                                        "",
                                        aux["url"])
            if aux.get("inline_url"):
                aux["type"] = "inline"
                aux.pop("url")
            else:
                aux["type"] = "landing"
            # title and snippet
            title = []
            snippet = []
            if aux.get('title1'):
                title.append(aux["title1"].rstrip())
            else:
                aux["title1"] = ""
            if aux.get('title2'):
                title.append(aux["title2"].rstrip())
            else:
                aux["title2"] = ""
            if aux.get('text1'):
                snippet.append(aux["text1"].rstrip())
            else:
                aux["text1"] = ""
            if aux.get('text2'):
                snippet.append(aux["text2"].rstrip())
            else:
                aux["text2"] = ""
            k["title"] = " ".join(title)
            k["snippet"] = " ".join(snippet)
            # img block
            if 'avatars' not in aux["img"]["url"]:
                aux["img"]["url"] = '/'.join([
                    "https://yabs.yandex.ru/resource",
                    aux["img"]["url"]
                ])
            aux["img_url"] = aux["img"]["url"]
            useful_aux_keys = [
                "age_restriction",
                "_description",
                "_link_extensions",
                "alt",
                "banner_id",
                "context_id",
                "fadeAgreement",
                "fadePadding",
                "fadeText",
                "fadeTheme",
                "img",
                "img_retina",
                "img_url",
                "inline_url",
                "name",
                "order_id",
                "product",
                "text1",
                "text2",
                "title1",
                "title2",
                "type",
                "url",
            ]
            aux = {
                key: val
                for key, val in aux.iteritems()
                if key in useful_aux_keys
            }
            k['aux-data'] = aux
            if product not in self.allowed:
                return
            return k
        except Exception as e:
            self.logger.error('id= {}\terror: {}'.format(aux["banner_id"], e.message))

    def clone_with_veil(self, k, param):
        self.linkextension = {"banerid": "showid"}
        clone = deepcopy(k)
        if clone['__product'] == 'searchline':
            return self.clone_searchline_veil(clone, param)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        age_subst = [
            {
                'filter': "'#lr,eq,225'",
                'data': '0+'
            },
            {
                'filter': 'default',
                'data': ''
            }
        ]
        clone['text-subst'] = self.make_common_text_subst()
        clone['text-subst']['tld'] = param
        clone['text-subst']['age'] = age_subst

        desc = u'<br><br>После этого начнётся установка Яндекс.Браузера'
        for idx, _ in enumerate(clone['text-subst']['install_text']):
            clone['text-subst']['install_text'][idx]['data'] += desc
        aux = clone["aux-data"]
        aux['subst-fields'] = [
            'age_restriction',
            'guide_image',
            'install_text',
            {'legal': 'link'},
            'position',
            'url',
        ]
        if not get_age_check_in_sandbox(clone):
            aux['age_restriction'] = "${age}"
        aux["guide_image"] = "${guide_image}"
        aux["install_text"] = "${install_text}"
        aux["position"] = '${position}'
        aux["url"] = clone['link'] = "//browser.yandex.${tld}/download/"

        aux["banner_id"] = '_'.join([str(aux["banner_id"]).split("_")[0],
                                     'subst'])
        aux["_link_extensions"] = {"url": {"banerid": "showid"}}
        aux["legal"] = {
            "link": "https://yandex.${tld}/legal/browser_agreement",
            "linkText": u" условия лицензионного соглашения ",
            "text": u"Устанавливая Яндекс.Браузер, вы принимаете",
        }
        aux["type"] = "download"
        clone["internal-url"] = "{}/{}{}".format(
            self.hostname, self.prefix, aux["banner_id"])
        clone["aux-data"] = aux
        return clone

    def clone_with_veil_control(self, k, param):
        clone = deepcopy(k)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        age_subst = [
            {
                'filter': "'#lr,eq,225'",
                'data': '0+'
            },
            {
                'filter': 'default',
                'data': ''
            }
        ]
        clone['text-subst'] = {
            'age': age_subst,
            'tld': param,
            "browser": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": "chrome"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": "edge"
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": "msie"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "ff"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "opera"
                },
                {
                    "filter": "default",
                    "data": ""
                },
            ]
        }
        aux = clone["aux-data"]
        aux['subst-fields'] = ['age_restriction', 'url', '_description']
        if not get_age_check_in_sandbox(clone):
            aux['age_restriction'] = "${age}"
        aux["banner_id"] = '_'.join([
            str(aux["banner_id"]).split("_")[0],
            'subst_landing'
        ])
        aux["url"] = aux["url"].replace('yandex.ru', 'yandex.${tld}')
        aux['_description'] += '_${browser}'
        clone["internal-url"] = "{}/{}{}".format(
            self.hostname, self.prefix, aux["banner_id"])
        clone["aux-data"] = aux
        return clone

    def clone_ext(self, k):
        clone = deepcopy(k)
        aux = clone["aux-data"]
        aux['text1'] = aux['text1'].replace('.ru', '')
        aux['text2'] = aux['text2'].replace('.ru', '')
        aux['title1'] = aux['title1'].replace('.ru', '')
        aux['title2'] = aux['title2'].replace('.ru', '')
        product = clone.get('__product')
        clone["filter"] = "'#lang,eq,ru'"
        store_link_substs = []
        for country in self.clone_country_config:
            subst = {
                'filter': "'#tld,eq,{tld}'".format(tld=country['country']),
                'data': country[product]
            }
            store_link_substs.append(subst)
        clone['text-subst'] = {
            "store_link": store_link_substs
        }
        aux['subst-fields'] = ['inline_url']
        aux["inline_url"] = clone["link"] = "{host}/{path}".format(
            host="https://chrome.google.com/webstore/detail",
            path="${store_link}")
        aux['_description'] += '_subst'
        clone["aux-data"] = aux
        return clone

    def clone_searchline_veil(self, clone, param):
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'",
        ])
        aux = clone['aux-data']
        aux["guide_image"] = "https://avatars.mds.yandex.net/get-serp/28672/\
a2731b7b-9fd6-48d2-b4ef-c82ae64f84c1/orig"
        aux['install_text'] = u'Нажмите на стрелку и выберите верхний файл.\
<br><br>После этого начнётся установка Яндекс.Строки'
        aux['position'] = 'right-top'
        aux['_link_extensions'] = {"url": {"banerid": "showid"}}
        aux['install_description'] = u'После этого начнётся установка \
Яндекс.Строки'
        aux['legal'] = {
            'link': "https://yandex.ru/legal/desktop_software_agreement/",
            'linkText': u" условия лицензионного соглашения",
            'text': u"Устанавливая Яндекс.Строку, вы принимаете",
        }
        aux['type'] = clone['type'] = 'download'
        aux['url'] = clone['link'] = "//yandex.ru/promo/searchline/download/"
        clone['aux-data'] = aux
        return clone

    def clone_searchline_veil_control(self, clone, param):
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'"
        ])
        aux = clone['aux-data']
        aux["banner_id"] = '_'.join([str(aux["banner_id"]).split("_")[0],
                                     'ctrl'])
        clone["internal-url"] = "{}/{}{}".format(self.hostname, self.prefix,
                                                 aux["banner_id"])
        clone['aux-data'] = aux
        return clone


if __name__ == '__main__':
    Teaser(**kwargs)
