#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys, os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))
from parser_filters import pack, parse
from delete_defaults_filters import delete_defaults, detect_device_target
from place import Place

class Touch_banner(Place):

    def customFormat(self, k):
        self.fields_for_features.update({
            "bnImg": "image",
        })
        self.linkextension = {
            "atom_reqid": "reqid",
            "atom_bannerid": "$banner_id",
            "banerid": "showid",
            "host": "$host",
            "yandexuid": "uid"
        }
        product_parsed_from_description = k["aux-data"]["_description"].split("_")[0].lower()
        k["__product"] = k["aux-data"].get("product", product_parsed_from_description)
        k["__product"] == k["__product"].replace('autoru', 'auto')
        k["__textauthor"] = k["aux-data"].get("textauthor", "")
        k["bandits-weight"] = 1
        k["grouping-key"] = k["__product"]
        if k["__product"] == "searchapp":
            k["__product"] = "search"
        k["bandits-weight-expression"] = "MOBLTV*(10*EVENT_AD_INSTALL + 10*install + real_click)+1"
        k["fml-weight"] = 100500
        k["snippet"] = ""
        k["title"] = k["aux-data"]["bnAlt"]

        k["aux-data"]["_link_extensions"] = {"bnHref": self.linkextension}

        k["aux-data"]["type"] = "banner"
        if "//" not in k["aux-data"]["bnImg"]:
            k["aux-data"]["bnImg"] = "".join(["https://yabs.yandex.ru/resource/", k["aux-data"]["bnImg"]])
        #optimize filters
        platform_target = detect_device_target(k)
        k['filter'] = pack(delete_defaults(k['filter']))
        if platform_target:
            if k['filter']:
                k['filter'] += "&" + platform_target
            else:
                k['filter'] += platform_target
        return k
