#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys, os , re

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))

from parser_filters import pack, parse
from delete_defaults_filters import delete_defaults, detect_device_target
from place import Place

class Touch_teaser(Place):
    def customFormat(self, k):
        self.fields_for_features.update({
            "t_color": "background",
            "button": "yes",
        })
        self.linkextension = {
            "atom_reqid": "reqid",
            "atom_bannerid": "$banner_id",
            "banerid": "showid",
            "host": "$host",
            "yandexuid": "uid",
            "af_sub5": "af_sub5"
        }
        product_parsed_from_description = k["aux-data"]["_description"].split("_")[0].lower()
        if product_parsed_from_description=='browserupdate':
            k["__product"]=product_parsed_from_description
        else:
            k["__product"] = k["aux-data"].get("product", product_parsed_from_description)
        k["__product"] = k["__product"].replace('auto','autoru')
        k["__textauthor"] = k["aux-data"].get("textauthor", "")
        k["grouping-key"] = k["__product"]+"_teaser"
        k["bandits-weight-expression"] = "(10*EVENT_AD_INSTALL + 10*install + real_click)+1"
        k["fml-weight-expression"] = "MOBLTV"
        if "b_image" in k["aux-data"] and k["aux-data"]["b_image"]["url"]:
            if "avatars.mds.yandex.net" not in k["aux-data"]["b_image"]["url"]:
                k["aux-data"]["b_image"]["url"]="https://yabs.yandex.ru/resource/"+k["aux-data"]["b_image"]["url"]
        if "s_image" in k["aux-data"] and k["aux-data"]["s_image"]["url"]:
            if "avatars.mds.yandex.net" not in k["aux-data"]["s_image"]["url"]:
                k["aux-data"]["s_image"]["url"]="https://yabs.yandex.ru/resource/"+k["aux-data"]["s_image"]["url"]
        k["aux-data"]["url"]=k["aux-data"]["url"].replace('af_siteid=bk','af_siteid=atom')
        k["snippet"] = ""
        k["title"] = k["aux-data"]["title"]
        k["aux-data"]["_link_extensions"] = {"url": self.linkextension}
        k["aux-data"]["af_sub5"]="atom_prod"

        # Health is given higher coefficient in bandits-weight
        # But we show it only if Search or Browser is already installed
        if k["__product"] == 'health':
            k["filter"] += "&(" + "|".join([
                "'#products,match,yabrowser'",
                "'#products,match,com.yandex.browser'",
                "'#products,match,ru.yandex.mobilesearch'",
                "'#products,match,ru.yandex.searchplugin'"
            ]) + ")"
        if k["__product"]=="taxi" and "adgroup=" in k["aux-data"]["url"]:
            k["aux-data"]["url"]="&".join([x+"_atom" if 'adgroup' in x else x for x in k["aux-data"]["url"].split("&")])

        k["aux-data"]["url"]=re.sub('(&|\?)[^&=]+={[^&=]+}','',k["aux-data"]["url"])
        return k

