#!/usr/bin/env python
# -*- coding: utf-8 -*-

from copy import deepcopy
from place import Place


class VideoWizard(Place):
    def customFormat(self, k):
        self.fields_for_features.update({
            "button_no": "no",
            "button_yes": "yes",
            "link": "link",
            "type": "type",
        })
        k["bandits-weight-expression"] = "1+LTV*SOFT_EXPORT_EVENT_install"
        k["fml-weight"] = 100

        product_parsed_from_description = k['aux-data'].get('_description').split('_')[0]
        k["__product"] = k["aux-data"].get("__product")
        if k['__product'] is None:
            k['__product'] = product_parsed_from_description

        k["grouping-key"] = "distribution"

        for substr in (
            "browser.yandex",
            "element.yandex",
            "home.yandex",
            "set.yandex",
            "yandex_browser",
        ):
            if substr in k["aux-data"]["link"]:
                k["aux-data"]["_link_extensions"] = {
                    "link": self.linkextension
                }

        k["title"] = k["aux-data"]["title"]
        k["snippet"] = k["aux-data"].get("snippet", "")
        if k["__product"] in self.allowed:
            return k
        else:
            self.logger.info('Custom format filtered out: {} product:{}'.format(
                k['aux-data']['_description'],
                k['__product']
            ))
