#!/usr/bin/env python
# -*- coding: utf-8 -*-

from copy import deepcopy
from place import Place
import re


class Wizard(Place):
    def customFormat(self, k):
        self.fields_for_features.update({
            "image": "image",
            "button_no": "no",
            "button_yes": "yes",
            "install_text": "veiltext",
            "extension_link": "link",
            "type": "type",
        })
        aux = k['aux-data']
        if not aux.get('title'):
            return
        if any(
            mobile_identifier in aux['_description'].lower()
            for mobile_identifier in ('android', 'ipad', 'ios', 'searchapp')
        ):
            k["bandits-weight-expression"] = "(1+EVENT_AD_INSTALL+install)"
            k["fml-weight-expression"] = "MOBLTV"
        else:
            k["bandits-weight-expression"] = "(1+SOFT_EXPORT_EVENT_install)"
            k["fml-weight-expression"] = "LTV"
        if "bandits-weight" in k:
            k.pop("bandits-weight", None)
        product_from_description = aux.get('_description').split('_')[0]
        k["__product"] = aux.get("__product") or product_from_description
        k['__product'] == k['__product'].replace('searchapp', 'search')
        k['__product'] == k['__product'].replace('set-home', 'sethome')
        k["grouping-key"] = "distribution"

        for substr in ('browser.yandex', 'yandex.com.tr/browser/',
                       'element.yandex', 'home.yandex', 'set.yandex',
                       'yandex_browser'):
            if substr in aux["extension_link"]:
                aux["_link_extensions"] = {
                    "extension_link": self.linkextension
                }

        if "extension_link" in aux and "&banerid=" in aux["extension_link"]:
            aux["extension_link"] = re.sub("&banerid=[0-9]+", "",
                                           aux["extension_link"])
        if aux.get("image") and "//" not in aux["image"]:
            aux["image"] = "{}{}".format("https://yabs.yandex.ru/resource/",
                                         aux["image"])
        if aux.get("image_retina") and "//" not in aux["image_retina"]:
            aux["image_retina"] = "{}{}".format(
                "https://yabs.yandex.ru/resource/",
                aux["image_retina"])
        k["title"] = aux["title"]
        k["snippet"] = aux.get("snippet") or ''
        # Don't show distribution for the SERPs from home example link
        k["filter"] += "&'#referer,not_match,%example_source%'"
        if (
            k.get('aux-data', {}).get('type') == 'download' and
            'windows' not in k.get('filter')
        ):
            return  # filter out type=download banners without filter on OS
        allowed_aux_keys = [
            '__product',
            '_atom_lang',
            '_atom_url',
            '_description',
            '_internal_url',
            '_link_extensions',
            'banner_id',
            'button_no',
            'button_yes',
            'color_background',
            'context_id',
            'counter_suffix',
            'data_ts',
            'extension_link',
            'grouping-key',
            'guide_image',
            'image',
            'image_retina',
            'install_description',
            'install_text',
            'legal',
            'name',
            'order_id',
            'product',
            'snippet',
            'title',
            'type',
            'wizard_design',
        ]
        aux = {
            key: value
            for key, value
            in aux.iteritems()
            if key in allowed_aux_keys
        }
        k['aux-data'] = aux
        if k["__product"] in self.allowed:
            return k
        else:
            self.logger.info(
                'Custom format filtered out: {} product:{}'.format(
                    k['aux-data']['_description'], k['__product'])
            )

    def cook_tld_subst(self):
        tld = []
        for country in self.clone_country_config:
            subst = {'filter': "'#lr,eq,{lr}'".format(lr=country['lr']),
                     'data': country['country']}
            tld.append(subst)
        return tld

    def clone_searchline_veil(self, clone, param):
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'"
        ])
        aux = clone['aux-data']
        aux['_link_extensions'] = {"extension_link": {"banerid": "showid"}}
        aux['install_description'] = u'После этого начнётся установка \
Яндекс.Строки'
        aux['legal'] = {
            'link': "https://yandex.ru/legal/desktop_software_agreement/",
            'linkText': u" условия лицензионного соглашения",
            'text': u"Устанавливая Яндекс Строку, вы принимаете",
        }
        aux['guide_image'] = "https://avatars.mds.yandex.net/get-serp/28672/\
a2731b7b-9fd6-48d2-b4ef-c82ae64f84c1/orig"
        aux["install_text"] = u'Нажмите кнопку, на которую указывает стрелка'
        aux['position'] = 'right-top-guide'
        aux['type'] = clone['type'] = 'download'
        aux['extension_link'] = clone['link'] = "//yandex.ru/promo/searchline/download/"
        clone['aux-data'] = aux
        return clone

    def clone_with_veil(self, k, param):
        clone = deepcopy(k)
        if clone['__product'] == 'searchline':
            return self.clone_searchline_veil(clone, param)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        clone['text-subst'] = {
            'tld': self.cook_tld_subst(),
            "position": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": "left-bottom"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": "center-bottom"
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": "center-bottom"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "right-top-guide"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "right-top-guide"
                },
            ],
            "install_text": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": u'Нажмите кнопку, на которую указывает стрелка\
<br>После этого начнётся установка Яндекс.Браузера'
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": u'Нажмите кнопку «Выполнить» на панели внизу\
<br>После этого начнётся установка Яндекс.Браузера'
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": u'Нажмите кнопку «Выполнить» на панели внизу\
<br>После этого начнётся установка Яндекс.Браузера'
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": u'Нажмите на синюю стрелку и выберите верхний файл'
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": u'Нажмите на стрелку и выберите верхний файл'
                },
            ],
            "guide_image": [
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "https://avatars.mds.yandex.net/get-serp/15230/\
8b832e8e-5ce2-435c-ab15-299973513b9c/orig",
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "https://avatars.mds.yandex.net/get-serp/15207/\
4337a6df-f7a6-45fd-89fd-df8c142e7dbe/orig",
                },
                {
                    "filter": "default",
                    "data": ""
                },
            ]
        }
        aux = clone["aux-data"]
        aux['subst-fields'] = [
            'guide_image',
            'install_text',
            {'legal': 'link'},
            'position',
            'extension_link',
        ]
        aux["guide_image"] = "${guide_image}"
        aux["install_description"] = u"После этого начнётся установка \
Яндекс.Браузера"
        aux["install_text"] = "${install_text}"
        aux["position"] = '${position}'
        aux["_link_extensions"] = {"extension_link": {"banerid": "showid"}}
        aux["extension_link"] = "//browser.yandex.${tld}/download/"
        aux["legal"] = {
            "link": "https://yandex.${tld}/legal/browser_agreement",
            "linkText": u" условия лицензионного соглашения",
            "text": u"Устанавливая Яндекс Браузер, вы принимаете",
        }
        aux["type"] = "download"
        clone["aux-data"] = aux
        return clone

    def clone_searchline_veil_control(self, clone, param):
        clone['filter'] = '&'.join([
            "('#lr,eq,977'|'#lr,eq,225')",
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'",
            "'#uat:BrowserName,eq,YandexBrowser'",
        ])
        clone['text-subst'] = {
            "browser": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": "chrome"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": "edge"
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": "msie"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "ff"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "opera"
                },
                {
                    'filter': "'#uat:BrowserName,eq,YandexBrowser'",
                    'data': u'Нажмите кнопку, на которую указывает стрелка'
                }
            ]
        }
        aux = clone['aux-data']
        aux['subst-fields'] = ['_description']
        aux['_description'] += '_${browser}'
        aux["banner_id"] = '_'.join([str(aux["banner_id"]).split("_")[0],
                                     'ctrl'])
        clone["internal-url"] = "{}/{}{}".format(self.hostname, self.prefix,
                                                 aux["banner_id"])
        clone['aux-data'] = aux
        return clone

    def clone_with_veil_control(self, k, param):
        clone = deepcopy(k)
        if clone['__product'] == 'searchline':
            return self.clone_searchline_veil_control(clone, param)
        clone["filter"] = '&'.join([
            "'#lang,eq,ru'",
            "'#ua,ic_match,%windows%'",
            "'#uat:isMobile,eq,false'"
        ])
        clone['text-subst'] = {
            'tld': param,
            "browser": [
                {
                    "filter": "'#uat:BrowserName,eq,Chrome'",
                    "data": "chrome"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Edge'",
                    "data": "edge"
                },
                {
                    "filter": "'#uat:BrowserName,eq,MSIE'",
                    "data": "msie"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Firefox'",
                    "data": "ff"
                },
                {
                    "filter": "'#uat:BrowserName,eq,Opera'",
                    "data": "opera"
                },
            ]
        }
        aux = clone["aux-data"]
        aux['subst-fields'] = ['extension_link', '_description']
        aux["extension_link"] = aux["extension_link"].replace(
            'yandex.ru', 'yandex.${tld}')
        aux['_description'] += '_${browser}'
        aux["banner_id"] = aux['_internal_url'] = '_'.join([
            str(aux["banner_id"]).split("_")[0],
            'subst_landing'
        ])
        clone["internal-url"] = "{}/{}{}".format(
            self.hostname, self.prefix, aux["banner_id"])
        clone["aux-data"] = aux
        clone["link"] = aux["extension_link"]
        return clone

    def clone_ext(self, k):
        clone = deepcopy(k)
        aux = clone["aux-data"]
        aux['title'] = aux['title'].replace('.ru', '')
        if aux.get('snippet'):
            aux['snippet'] = aux['snippet'].replace('.ru', '')
        product = clone.get('__product')
        clone["filter"] = "'#lang,eq,ru'"
        store_link_substs = []
        for country in self.clone_country_config:
            subst = {
                'filter': "'#tld,eq,{tld}'".format(tld=country['country']),
                'data': country[product]
            }
            store_link_substs.append(subst)
        clone['text-subst'] = {
            "store_link": store_link_substs
        }
        aux['subst-fields'] = ['extension_link']
        aux["extension_link"] = "https://chrome.google.com/webstore/detail/${store_link}"
        aux['_description'] += '_subst'
        clone["aux-data"] = aux
        clone["link"] = aux["extension_link"]
        return clone
