#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import yt.wrapper as yt
from pytils import yt_config_set_defaults
import requests
import pdb
import datetime
import json
import numpy as np
from colored import fg, bg, attr
from v4_daily_yt import get_dictionary_from_stat, reverse_dict, HEADERS
from pytils import get_yt_exists

yt_exists = get_yt_exists(yt)


STAT_URL = "https://stat.yandex-team.ru/Distribution/Others/AtomBanners/v4_daily?scale=d&_incl_fields=trueinstalls&_incl_fields=installs&browser=1&candidate=3&element={element}&for=&lang=0&os=1&product=0&service=4&testid=0&date_min={from_}+00%3A00%3A00&date_max={to_}+23%3A59%3A59&_type=json&_raw_data=1"
ARCANUM_HEADERS = {}


def parse_feature_stats(str_):
    split_ = str_.split(', ')
    dct = {x.split(': ')[0]: float(x.split(': ')[1])
           for x in split_}
    return dct


def get_arcanum_token(path='.arcanum_token'):
    with codecs.open(path, 'r', 'utf8') as f:
        return f.read().strip()


def get_stat_element(element, fml_name_to_host_name, proper_name):
    if proper_name not in fml_name_to_host_name:
        return
    host_name = fml_name_to_host_name[proper_name]
    if host_name + '.training' in element:
        return element[host_name + '.training']
    elif host_name in element:
        print('{s}.training not found, using just {s}'.format(s=host_name))
        return element[host_name]


def main():
    global ARCANUM_HEADERS
    parser = argparse.ArgumentParser()
    parser.add_argument('inputfolder')
    args = parser.parse_args()

    ARCANUM_HEADERS = {'Authorization': 'OAuth {}'.format(get_arcanum_token())}

    yt_config_set_defaults(yt, None)

    formulae = yt.list(
        args.inputfolder,
        absolute=True
    )

    from_date, to_date = args.inputfolder.split('/')[-1].split('-')
    from_date = datetime.datetime.strptime(from_date, '%Y%m%d').date()
    to_date = datetime.datetime.strptime(to_date, '%Y%m%d').date()

    element = reverse_dict(
        get_dictionary_from_stat('vcfs::atombanners_element')
    )

    req = requests.get('https://a.yandex-team.ru/api/tree/blob/'
                       'trunk/arcadia/quality/'
                       'pers/ml/atom/distribution/conveyor/'
                       'runner/config/pbconf.json',
                       verify=False, headers=ARCANUM_HEADERS)
    conf = json.loads(req.content.decode('utf8'))

    fml_name_to_host_name = {
        x['fml_name']: (x['filter_config']['host_regex']
                        .replace('^', '')
                        .replace('$', ''))
        for x in conf['fml_configs']
    }

    for formula in formulae:
        proper_name = formula.split('/')[-1]
        if 'combined_target' in proper_name:
            print('warning: skipping combined target formula {}'.format(
                proper_name
            ))
            continue
        element_stat = get_stat_element(
            element, fml_name_to_host_name, proper_name
        )
        if not element_stat:
            print('warning: corresponding element not found for {}'.format(
                proper_name
            ))
            continue
        if not yt_exists(formula + '/features.stats'):
            print('warning: no features.stats table for {}'.format(
                proper_name
            ))
            continue
        stat_req = requests.get(
            STAT_URL.format(
                from_=from_date.strftime('%Y-%m-%d'),
                to_=to_date.strftime('%Y-%m-%d'),
                element=element_stat
            ),
            headers=HEADERS
        )
        stat = json.loads(stat_req.content.decode('utf8'))['values']
        for rec in yt.read_table(
            formula + '/features.stats',
            raw=False,
            format=yt.JsonFormat()
        ):
            target = parse_feature_stats(rec['value'])['NonZeroPercentage']
            break
        stat_target_name = ('trueinstalls' if '_install' not in proper_name
                            else 'installs')
        stat_target = (lambda x: sum(x) / len(x))(
            [x[stat_target_name] / x['shows'] for x in stat]
        )
        diffperc = (target - stat_target) / stat_target
        if abs(diffperc) < 0.1:
            color = 'green'
        elif 0.1 <= abs(diffperc) < 0.2:
            color = 'yellow'
        else:
            color = 'red'
        print('{}formula: {}, target: {:f}, stat_target: {:f}, '
              'difference: {:f} ({:.1%}){}'.format(
                  fg(color),
                  proper_name,
                  target,
                  stat_target,
                  target - stat_target,
                  diffperc,
                  attr('reset')
              ))

if __name__ == "__main__":
    main()
