#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import datetime
import traceback
import argparse
import json
import pdb
import time
import copy
import requests
try:
    JSONDecodeError = json.decoder.JSONDecodeError
except AttributeError:
    JSONDecodeError = ValueError
try:
    basestring
except NameError:
    basestring = str
from collections import defaultdict

URL = 'http://atom-admin.n.yandex-team.ru/atom/api/v1/'
i = 0


# To add testids, create a file named `svnpath` in the script directory
# containing the path to a directory linked to
# trunk/arcadia/junk/pecheny/monitorings


def get_token():
    with codecs.open('.atom_token', 'r') as f:
        return f.read().rstrip()


HEADERS = {'Authorization': 'Token {}'.format(get_token())}


def edit_creatives(creatives_json):
    edited_json = []
    for banner in creatives_json:
        if args.filter:
            banner["filter"] = args.filter + "&" + banner["filter"]
        edited_json.append(banner)
    return edited_json


def get_creatives(collection):
    req = None
    try:
        req = requests.get(URL + 'collections/' + collection,
                           headers=HEADERS)
    except requests.exceptions.ConnectionError:
        raise Exception('connection error on {}'.format(collection))
    if req.content.startswith('<h1>Not Found</h1>'):
        raise Exception('collection {} not found'.format(collection))
        return []
    try:
        return json.loads(req.content.decode('utf8'))
    except:
        return []


def delete_creatives(collection):
    requests.delete(URL + 'collections/' + collection,
                          headers=HEADERS)
    all_keys = get_creatives('all_keys')
    all_keys.remove(collection)
    post_creatives('all_keys', all_keys, reqtype='put')


def get_prod(all_keys):
    result = defaultdict(lambda: set())
    for x in all_keys:
        if isinstance(x, basestring):
            x = {x: [x]}
        k = next(iter(x.keys()))
        for y in x[k]:
            result[y].add(k)
    return result


def post_creatives(collection, data, reqtype='post'):
    reqtype = reqtype.lower()
    url = URL + 'collections/' + collection
    req = None
    while req is None:
        try:
            req = getattr(requests, reqtype)(url, headers=HEADERS, json=data)
        except:
            print('error occurred: {}'.format(traceback.format_exc()))
            pdb.set_trace()
            time.sleep(3)
            print('retrying')
    if req.status_code != 200:
        raise Exception(req.content.decode('utf8'))


def get_unique_bannerid(bannerids):
    global i
    bannerid = datetime.datetime.now().strftime('%s') + str(i)
    while bannerid in bannerids:
        i += 1
        bannerid = datetime.datetime.now().strftime('%s') + str(i)
    return bannerid


def sanitize(lst):
    return lst.replace('/', '_')


def get_collections():
    all_keys = get_creatives('all_keys')
    collections = {}
    for key in all_keys:
        if isinstance(key, basestring):
            creatives = None
            while creatives is None:
                try:
                    creatives = get_creatives(key)
                except:
                    print('error on {}'.format(key))
                    break
            if creatives:
                collections[key] = creatives
        else:
            creatives = None
            key_ = next(iter(key))
            while creatives is None:
                try:
                    creatives = get_creatives(key_)
                except:
                    print('error on {}'.format(key_))
                    break
            if creatives:
                collections[key_] = creatives
    return collections


def find_waldo():
    result = {}
    collections = get_collections()
    for collection in collections:
        for creative in collections[collection]:
            result[creative['internal-url'].split('/')[-1]] = collection
    return result


def multiply_creatives(sourcelists, targetlists):
    all_keys = get_creatives('all_keys')
    collections = get_collections()
    unique_bannerids = set()
    for collection in collections:
        print('processing {}'.format(collection))
        for creative in collections[collection]:
            unique_bannerids.add(
                creative.get('internal-url', '').split('/')[-1]
            )
    target = defaultdict(lambda: [])
    for sourcelist in sourcelists:
        source = get_creatives(sourcelist)
        if not source:
            print(
                'List {} does not exist, but is '
                'included in all_keys; please remove it'.format(sourcelist)
            )
            continue
        for targetlist in targetlists:
            target[targetlist].extend(copy.deepcopy(source))
            for x in target[targetlist][-len(source):]:
                bannerid = get_unique_bannerid(unique_bannerids)
                x['internal-url'] = '{}/{}'.format(
                    # sanitize(targetlist),
                    x['internal-url'].split('/')[0],
                    bannerid
                )
                unique_bannerids.add(bannerid)
    for targetlist in target:
        print('posting {}'.format(targetlist))
        try:
            post_creatives(targetlist, edit_creatives(target[targetlist]))
        except Exception:
            post_creatives(targetlist, target[targetlist], reqtype='PUT')
        all_keys = get_creatives('all_keys')
        if targetlist not in all_keys:
            all_keys.append(targetlist)
        print('modifying all_keys')
        post_creatives('all_keys', all_keys, reqtype='PUT')


def test_multiply_creatives():
    multiply_creatives('distr_wizard_ru', ['distr_wizard_ru_test'])
    delete_creatives('distr_wizard_ru_test')


def multiply_at_all_keys(sourcelist, targetlists):
    all_keys = get_creatives('all_keys')
    sourcelist = sourcelist[0]
    for e, key in enumerate(all_keys):
        if isinstance(key, dict) and sourcelist in key[next(iter(key.keys()))]:
            for targetlist in targetlists:
                if targetlist not in key[next(iter(key.keys()))]:
                    key[next(iter(key.keys()))].append(targetlist)
        elif key == sourcelist:
            all_keys[e] = {
                sourcelist: [sourcelist]
            }
            for targetlist in targetlists:
                all_keys[e][sourcelist].append(targetlist)

    print('modifying all_keys')
    post_creatives('all_keys', all_keys, reqtype='PUT')


def expandprod(sourcelists):
    result = set()
    for sourcelist in sourcelists:
        if not sourcelist.startswith('prod:'):
            result.add(sourcelist)
        else:
            all_keys = get_creatives('all_keys')
            for key in all_keys:
                if (isinstance(key, dict) and
                        sourcelist[5:] in key[next(iter(key.keys()))]):
                    result.add(next(iter(key.keys())))
                elif key == sourcelist[5:]:
                    result.add(sourcelist[5:])
    return sorted(result)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--sourcelist', '-s', action='append')
    parser.add_argument('--targetlist', '-t', action='append')
    parser.add_argument('--remove', '-r', action='append')
    parser.add_argument('--allkeys', action='store_true')
    parser.add_argument('--testids', '-ti')
    parser.add_argument('--filter', '-fi')
    global args
    args = parser.parse_args()
    if args.sourcelist and args.targetlist:
        if args.allkeys:
            multiply_at_all_keys(args.sourcelist, args.targetlist)
        else:
            args.sourcelist = expandprod(args.sourcelist)
            multiply_creatives(args.sourcelist, args.targetlist)
    if args.testids:
        with codecs.open('svnpath', 'r', 'utf8') as f:
            svnpath = f.read().rstrip()
        os.chdir(svnpath)
        os.system('svn up .')
        with codecs.open('testids.txt', 'r', 'utf8') as f:
            testids = {x for x in f.read().split('\n') if x}
        for ti in args.testids.split(','):
            testids.add(ti)
        with codecs.open('testids.txt', 'w', 'utf8') as f:
            f.write('\n'.join(sorted(testids)) + '\n')
        os.system('svn ci -m "added {}" testids.txt'
                  .format(args.testids))
    if args.remove:
        to_remove = {x.decode('utf8') for x in args.remove}
        collections = get_collections()
        for collection in collections:
            result = []
            for creative in collections[collection]:
                good = True
                for x in to_remove:
                    if x in json.dumps(creative, ensure_ascii=False):
                        print('found the culprit {} at list {}'.format(
                            x, collection
                        ))
                        good = False
                        break
                if good:
                    result.append(creative)
            if result != collections[collection]:
                print('posting result...')
                post_creatives(collection, result, reqtype='put')


if __name__ == "__main__":
    main()
