#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json
import datetime
from pytils import yt_config_set_defaults, make_logger
import yt.wrapper as yt


@yt.raw
class PromolibaGrep(object):

    def __init__(self, uuids):
        self.uuids = set(uuids.split(','))
        self.uuids.discard('')

    def __call__(self, rec):
        rec = rec.decode('utf8', errors='replace')
        if '-ATOMS-' in rec:
            rec = json.loads(rec)
            try:
                obj = json.loads(rec['EventValue'])
            except:
                obj = {}
            if (isinstance(obj, dict) and
                    'campaign_id' in obj and 'EventName' in rec):
                campaign_id = obj['campaign_id']
                try:
                    bannerid = campaign_id.split(';')[2]
                except IndexError:
                    bannerid = ''
                if 'uuid' in obj and obj['uuid'] in self.uuids:
                    yield json.dumps(
                        {
                            'uuid': obj['uuid'],
                            'bannerid': bannerid,
                            'timestamp': datetime.datetime.fromtimestamp(
                                int(rec['SendTimestamp'])
                            ).strftime(
                                '%Y-%m-%d %H:%M:%S'
                            )
                        }
                    )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('srcdate')
    parser.add_argument('uuids')
    args = parser.parse_args()

    yt_config_set_defaults(yt, None)

    args.uuids = args.uuids.decode('utf8', errors='replace')

    yt.run_map(PromolibaGrep(args.uuids),
               source_table=yt.TablePath(
        '//statbox/metrika-mobile-log/{}'.format(args.srcdate),
        columns=['EventValue', 'EventName', 'AppID',
                 'AppPlatform', 'SendTimestamp']
    ),
        destination_table='//home/personalization/promoliba_grep/{}_{}'.format(
            args.srcdate, args.uuids.replace(',', '_')
    )
    )


if __name__ == "__main__":
    main()
