#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
from prepare_atom_experiment import get_creatives, post_creatives


OPENING_BRACKETS = ['[', '(', '{']
CLOSING_BRACKETS = [']', ')', '}']


def matching_bracket(s):
    assert s in OPENING_BRACKETS or s in CLOSING_BRACKETS
    if s in OPENING_BRACKETS:
        return CLOSING_BRACKETS[OPENING_BRACKETS.index(s)]
    return OPENING_BRACKETS[CLOSING_BRACKETS.index(s)]


def find_matching_closing_bracket(s, index):
    s = list(s)
    i = index
    assert s[i] in OPENING_BRACKETS
    ob = s[i]
    cb = matching_bracket(ob)
    counter = 0
    while i < len(s):
        if s[i] == ob:
            counter += 1
        if s[i] == cb:
            counter -= 1
            if counter == 0:
                return i
        i += 1
    return None


def find_outermost_bracket_group(s, index):
    group = None
    stop = False
    mover = index
    while not stop and mover >= 0:
        mover = mover - 1
        if s[mover] in OPENING_BRACKETS:
            if mover < index < find_matching_closing_bracket(s, mover):
                group = (mover, find_matching_closing_bracket(s, mover))
    return group


def remove_outermost_bracket_group(s, index):
    group = find_outermost_bracket_group(s, index)
    if s[group[0] - 1] in {'&', '|'}:
        group = (group[0] - 1, group[1])
    return s[:group[0]] + s[group[1] + 1:]


def main():
    creatives = get_creatives('promoliba_EXP_exp')
    for creative in creatives:
        if '527' in creative['filter']:
            creative['filter'] = remove_outermost_bracket_group(
                creative['filter'],
                creative['filter'].index('527')
            )
            creative['ignore-default-filters'] = 1
    post_creatives('promoliba_EXP_exp', creatives, reqtype='put')


if __name__ == "__main__":
    main()
