#!/usr/bin/python
# -*- coding: UTF-8 -*-

'''
# To add new product:
1. Add creative in toloka collection:
    https://switch.v.yandex-team.ru/atom/collection/15518

2. Create project at toloka:
    https://toloka.yandex.com/requester
    login: ranking.gosha

3. Write instruction with screenshots

4. Add product to "products" dictionary in this config file

5. Add jenkins regular job:
    http://jenkinstat.haze.yandex.net:8080/view/proj.distrportal/
    - copy example from
    ~/proj.distrportal/job/proj.distrportal.toloka_give_assignments_sethome/

6. Add statface report to the mart
    https://stat.yandex-team.ru/Mart/User/chikachoff/AtomRecallMetric
'''

URL_PATTERN = 'https://yandex.ru/?source=toloka&id={_id}_{stage}\
&product={product}&date={date}'

# 'banerid' is afterslash part of creative internal-url in atom list
# Example: for "internal-url": "portal_popup/toloka_sethome"
#          banerid is "toloka_sethome"
products = {
    'sethome': {
        'banerid': 'toloka_sethome',
        'pool_zero': '371410',
        'pool_one': '371414',
        'pool_two': '371575',
        'pool_three': '371355',
        'project_descriptor': u'Поиск',
        'right_answer': '8.22.5',
        'stat_path': 'Distribution/Adhoc/AtomRecallMetric',
        'tasks_count': 100,
    },
    'stroka': {
        'banerid': 'toloka_searchline',
        'pool_zero': '271155',
        'pool_one': '175468',
        'pool_two': '175545',
        'pool_three': '301816',
        'project_descriptor': u'Строка',
        'right_answer': '1.9.8',
        'stat_path': 'Distribution/Adhoc/AtomRecallMetricStroka',
        'tasks_count': 100,
    },
    'searchios': {
        'banerid': 'toloka_search_ios',
        'pool_zero': '271133',
        'pool_one': '167151',
        'pool_two': '167158',
        'pool_three': '301826',
        'project_descriptor': u'iOS-приложения',
        'right_answer': '112',
        'stat_path': 'Distribution/Adhoc/AtomRecallMetricSearchios',
        'tasks_count': 100,
    },
    'searchandroid': {
        'banerid': 'toloka_search_android',
        'pool_zero': '349471',
        'pool_one': '349475',
        'pool_two': '172978',
        'pool_three': '301847',
        'project_descriptor': u'Android-приложения',
        'right_answer': '33963',
        'stat_path': 'Distribution/Adhoc/AtomRecallMetricSearchAndroid',
        'tasks_count': 100,
    },
    'broios': {
        'banerid': 'toloka_bro_ios',
        'pool_zero': '271174',
        'pool_one': '177752',
        'pool_two': '177757',
        'pool_three': '301889',
        'project_descriptor': u'Браузера на iPhone',
        'right_answer': '17.3',
        'stat_path': 'Distribution/Adhoc/AtomRecallMetricBroios',
        'tasks_count': 100,
    },
    'broandroid': {
        'banerid': 'toloka_bro_android',
        'pool_zero': '349565',
        'pool_one': '349577',
        'pool_two': '177855',
        'pool_three': '301897',
        'project_descriptor': u'Браузера на Android',
        'right_answer': '17.1',
        'stat_path': 'Distribution/Adhoc/AtomRecallMetricBroAndroid',
        'tasks_count': 100,
    },
    'brodesktop': {
        'banerid': 'toloka_bro_desktop',
        'pool_zero': '271111',
        'pool_one': '178846',
        'pool_two': '178847',
        'pool_three': '301905',
        'project_descriptor': u'Браузера (',
        'right_answer': '17.3.0.1785',
        'stat_path': 'Distribution/Adhoc/AtomRecallMetricBroDesktop',
        'tasks_count': 100,
    },
}
