#!/usr/bin/python
# -*- coding: UTF-8 -*-

from __future__ import division

import argparse
import json
from pprint import pprint
import urllib
import urllib2
import urlparse
from datetime import date, datetime, timedelta

from atomhelper_new import Atomhelper
from config import products as cfg
from config import URL_PATTERN
from main import update_stat
from mordahelper import Morda
from tolokahelper import TolokaHelper
import yt.wrapper as yt

# Config
DATE_YESTERDAY = (date.today() - timedelta(days=1)).isoformat()
STAT_HOST = 'https://stat.yandex-team.ru/'
yt.config['token'] = 'AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
yt.config.set_proxy('hahn.yt.yandex.net')


def read_stat(fielddate, url):
    headers = {'StatRobotUser': 'robot_aydogank',
               'StatRobotPassword': 'Aish3ohy9u'}
    params = {
        'scale': 'd',
        'date_min': '{}'.format(fielddate),
        'date_max': '{}'.format(fielddate),
        'type': 'json',
        '_raw_data': 1
    }
    url_parts = list(urllib2.urlparse.urlparse(url))
    query = dict(urllib2.urlparse.parse_qsl(url_parts[4]))
    query.update(params)
    url_parts[4] = urllib.urlencode(query)
    url = urlparse.urlunparse(url_parts)

    print url
    req = urllib2.Request(url=url, headers=headers)
    response = urllib2.urlopen(req, timeout=30)
    res = json.load(response)
    return res['values']


def calc_metrics(morda_df, atom_df, project_descriptor, right_answer,
                 product, stat_path, date):
    th = TolokaHelper(project_descriptor=project_descriptor, _date=date,
                      url_pattern=URL_PATTERN)
    print '\n{delim}\n\nDate: {date}\t|\tProduct: {prod}'.format(
        delim='-------' * 15, date=date, prod=product
    )
    pools_daily = th.get_stage_pools_daily()
    th.autoreview_results(pools_daily, stage=3)
    # this creates th.toloka_stages
    th.fetch_toloka_results(pools_daily, delay=True)
    data = {'toloka_3': len(th.toloka_stages[0]['indices'])}
    print 'toloka metrics calculated'
    print 'Data:\n{}'.format(data)

    morda = Morda(date=date, url_pattern=URL_PATTERN, delay=True)
    morda_metrics = morda.calc_morda_metrics_delay(product=product, stage=3)
    data['morda_3'] = morda_metrics
    print 'Data:\n{}'.format(data)

    atom = Atomhelper(date=date, product=product, url_pattern=URL_PATTERN)
    atom.fill_stages_source(toloka_stages=th.toloka_stages,
                            bannerid=cfg[product]['banerid'])
    print atom.stages
    # atom.write_debug_log_for_noshows()
    data.update(atom.calc_delay_metrics_source(data))
    print 'Data:\n{}'.format(data)

    ##########################################################################
    # Old data
    #
    #
    DAYS_2_BEFORE_CALC_DATE = (
        datetime.strptime(date, '%Y-%m-%d').date() - timedelta(days=2)
    ).isoformat()
    print '\nDAYS_2_BEFORE_CALC_DATE: {}'.format(DAYS_2_BEFORE_CALC_DATE)
    print 'Fetching DAYS_2_BEFORE_CALC_DATE data'

    th = TolokaHelper(project_descriptor=project_descriptor,
                      _date=DAYS_2_BEFORE_CALC_DATE,
                      url_pattern=URL_PATTERN)
    pools_daily = th.get_stage_pools_daily()
    th.fetch_toloka_results(pools_daily)
    initial_data = [{
        'toloka_0': len(th.toloka_stages[0]['indices']),
        'toloka_1': len(th.toloka_stages[1]['indices']),
        'toloka_2': len(th.toloka_stages[2]['indices']),
        'fielddate': th.date
    }]
    morda = Morda(date=DAYS_2_BEFORE_CALC_DATE, url_pattern=URL_PATTERN)
    morda_metrics = morda.calc_morda_metrics(toloka_stages=th.toloka_stages,
                                             product=product)
    initial_data[0]['morda_0'] = morda_metrics[0]
    initial_data[0]['morda_1'] = morda_metrics[1]
    initial_data[0]['morda_2'] = morda_metrics[2]

    atom = Atomhelper(date=DAYS_2_BEFORE_CALC_DATE,
                      product=product, url_pattern=URL_PATTERN)
    atom.fill_stages_source(toloka_stages=th.toloka_stages,
                            bannerid=cfg[product]['banerid'])
    # atom.write_debug_log_for_noshows()
    initial_data = atom.calc_metrics_source(initial_data)
    #
    #
    ##########################################################################
    if initial_data[0]:
        data.update(initial_data[0])
        pprint(data)

    # Uncomment me to update stat
    update_stat([data], stat_path)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('date')
    args = parser.parse_args()

    if args.date:
        calc_date = args.date
    else:
        calc_date = DATE_YESTERDAY

    morda = Morda(date=calc_date, url_pattern=URL_PATTERN)
    atom = Atomhelper(date=calc_date, product='_', url_pattern=URL_PATTERN)
    print 'len(morda.df): {}'.format(len(morda.df))
    print 'len(atom.df): {}'.format(len(atom.df))

    for product, params in cfg.iteritems():
        try:
            calc_metrics(
                morda_df=morda.df,
                atom_df=atom.df,
                date=calc_date,
                product=product,
                project_descriptor=params['project_descriptor'],
                right_answer=params['right_answer'],
                stat_path=params['stat_path'],
            )
        except Exception as e:
            print e
            pass


if __name__ == '__main__':
    main()
