#!/usr/bin/python
# -*- coding: UTF-8 -*-

from __future__ import division

import argparse
from datetime import date, timedelta
from config import URL_PATTERN
from config import products as cfg
from tolokahelper import TolokaHelper

# Config
date_yesterday = (date.today() - timedelta(days=1)).isoformat()
date = date_yesterday


def main():
    th = TolokaHelper(project_descriptor=u'Поиск',
                      _date=date,
                      url_pattern=URL_PATTERN)
    parser = argparse.ArgumentParser()
    parser.add_argument('product')
    args = parser.parse_args()
    product = args.product
    th.give_assignments(
        product=product,
        pool_zero=cfg[product]['pool_zero'],
        pool_one=cfg[product]['pool_one'],
        pool_two=cfg[product]['pool_two'],
        tasks_count=cfg[product]['tasks_count']
    )


if __name__ == '__main__':
    main()
