#!/usr/bin/python
# -*- coding: UTF-8 -*-

from __future__ import division

import argparse
import json
import requests
from datetime import date, timedelta

from config import URL_PATTERN
from config import products as cfg
from tolokahelper import TolokaHelper
from mordahelper import Morda
from atomhelper_new import Atomhelper
import yt.wrapper as yt

# Config
DATE_3_DAYS_AGO = (date.today() - timedelta(days=3)).isoformat()
DATE_2_DAYS_AGO = (date.today() - timedelta(days=2)).isoformat()
DATE_YESTERDAY = (date.today() - timedelta(days=1)).isoformat()

STAT_HOST = 'https://stat.yandex-team.ru/'
yt.config['token'] = 'AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
yt.config.set_proxy('hahn.yt.yandex.net')

# Voronka stages:
#   0. Requests from Toloka
#   1. Requests from Morda Frontend Access Log
#   2. Requests from Atom log
#   3. Answers from Atom log


def update_stat(rows, stat_path):
    requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'StatRobotUser': 'robot_aydogank',
                 'StatRobotPassword': 'Aish3ohy9u'},
        data={
            'name': stat_path,
            'scale': 'd',
            'data': json.dumps({'values': rows}),
        },
    )
    stat_url = ''.join([STAT_HOST, stat_path])
    print 'Stat updated\t{}'.format(stat_url)


def calc_metrics(morda_df, atom_df, project_descriptor, right_answer,
                 product, stat_path, date):
    th = TolokaHelper(project_descriptor=project_descriptor, _date=date,
                      url_pattern=URL_PATTERN)
    print '\n{delim}\n\nDate: {date}\t|\tProduct: {prod}'.format(
        delim='ololo' * 10, date=date, prod=product
    )
    pools_daily = th.get_stage_pools_daily()
    th.review_results(pools_daily, stage=0, right_answer=right_answer)
    th.review_results(pools_daily, stage=1)
    th.review_results(pools_daily, stage=2)
    th.fetch_toloka_results(pools_daily)
    data = [
        {
            'toloka_0': len(th.toloka_stages[0]['indices']),
            'toloka_1': len(th.toloka_stages[1]['indices']),
            'toloka_2': len(th.toloka_stages[2]['indices']),
            'fielddate': th.date
        }
    ]
    print 'toloka metrics calculated'
    print data

    ##########################################################################
    # Create skill, grant skill to good tolokers, start delayed pool
    #
    print 'creating skill for delayed pool...'
    skill_id = th.tlk.create_skill(
        name='{}_{}'.format(DATE_YESTERDAY, product),
        hidden=True,
        training=False,
        skill_ttl_hours=23)['id']
    print '..skill {} created'.format(skill_id)
    print 'granting new skill to good workers...'
    good_workers = th.get_stage0_good_workers(pools_daily)
    print good_workers
    for user_id in good_workers:
        th.tlk.set_worker_skill(skill_id=skill_id, user_id=user_id, value=1)
    print '{} workers granted skill {}'.format(len(good_workers), skill_id)
    print 'creating delayed pool'
    th.start_new_pool(original_pool_id=cfg[product]['pool_three'],
                      product=product, stage=3, tasks_count=100,
                      delay_skill=skill_id)
    #
    #
    ###########################################################################

    ###########################################################################
    # Continue with metrics
    morda = Morda(date=date, url_pattern=URL_PATTERN)
    morda_metrics = morda.calc_morda_metrics(toloka_stages=th.toloka_stages,
                                             product=product)
    data[0]['morda_0'] = morda_metrics[0]
    data[0]['morda_1'] = morda_metrics[1]
    data[0]['morda_2'] = morda_metrics[2]

    print 'Data:\n{}'.format(data)

    atom = Atomhelper(date=date, product=product, url_pattern=URL_PATTERN)
    atom.fill_stages_source(toloka_stages=th.toloka_stages,
                            bannerid=cfg[product]['banerid'])
    atom.write_debug_log_for_noshows()
    data = atom.calc_metrics_source(data)
    data = [{k: v for k, v in data[0].items()
            if not k.endswith('_3')}]
    print data
    update_stat(data, stat_path)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('date')
    args = parser.parse_args()

    if args.date:
        calc_date = args.date
    else:
        calc_date = DATE_2_DAYS_AGO

    morda = Morda(date=calc_date, url_pattern=URL_PATTERN)
    atom = Atomhelper(date=calc_date, product='_', url_pattern=URL_PATTERN)
    print 'len(morda.df): {}'.format(len(morda.df))
    print 'len(atom.df): {}'.format(len(atom.df))

    for product, params in cfg.iteritems():
        print 'calculating metric\t{0}\t{1}'.format(calc_date, product)
        calc_metrics(
            morda_df=morda.df,
            atom_df=atom.df,
            date=calc_date,
            product=product,
            project_descriptor=params['project_descriptor'],
            right_answer=params['right_answer'],
            stat_path=params['stat_path'],
        )


if __name__ == '__main__':
    main()
