# coding: utf-8

import json
from hashlib import sha1
import yt.wrapper as yt
from collections import Counter


yt.config['token'] = 'AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
yt.config.set_proxy('hahn.yt.yandex.net')
yt.config.CREATE_RECURSIVE = True

element_to_selector = {
            'Wizard': "//div[contains(concat(' ', @class, ' '), ' z-default-search ')]",
            'Portal_popup': 'distr-popup',
            'Stripe': 'head-stripe',
            'Promofooter': 'distro',
            'Smart_banner': 'smart-info',
            'Mobilefooter': 'footer_type_distro',
        }

def read_import_config():
    with open('../import_config.json') as fp:
        import_config = json.load(fp)
    return import_config

def get_placeid_for_element(element):
    for place, params in read_import_config().iteritems():
        if element == place:
            return params['placeid'][0]

def main():
    ELEMENT = 'Wizard'
    # TABLE = '//home/tellurium/distribution/incoming/table'
    TABLE = '//home/atom/chikachoff/table'
    URL_PATTERN = 'https://hamster.yandex.ru/search/?text=malta&lr=213&relev=atom_wizard_force-candidates={}'

    placeid = get_placeid_for_element(ELEMENT)
    filename = '../' + placeid + '.json'
    print filename
    with open(filename) as fp:
        data = json.load(fp).get(placeid)
#    products = Counter()
#    for elem in data:
#        products[(elem.get('aux-data').get('__product'))] += 1
#    print products
# 'browser': 4696, u'sethome': 315, u'set': 302, u'home': 131, u'searchline': 16, u'Yobject': 12, None: 11, u'helper': 8, u'vb': 2, u'set-home': 1
    result = list()
    for elem in data:
        url = URL_PATTERN.format(elem['internal-url'])
        os = 'Windows'
        if elem.get('aux-data').get('__product') in ('set', 'sethome', 'home', 'browser'):
            browser = 'Chrome'
        elif elem.get('aux-data').get('__product') in ('searchline',):
            browser = 'YandexBrowser'
        else:
            continue
        result.append({
            'url': url,
            # 'os': os,
            # 'browser': browser,
            # 'hash': sha1(str(elem)).hexdigest(),
            'xpath': element_to_selector[ELEMENT],
            'language': 'ru',
            'region': 'yandex'})
    yt.write_table(TABLE, result, format=yt.JsonFormat())

if __name__ == '__main__':
    main()
