# ! coding: utf:8
from selenium import webdriver
import urlparse
import urllib
import time
from PIL import Image

def save_screenshoot(url, class_selector=None):
    browser = webdriver.Remote(
       command_executor="http://test:test@sg.yandex-team.ru:4444/wd/hub",
       desired_capabilities={
                # "browserName": "firefox",

                "browserName": "chrome",
                "version": "53",

                # "browserName": "iOS",
                # "version": "8.4"

                # "browserName": "android-phone",
                # "version": "5.1"

 # "browserName": "Android"

                # "version": "47",
                # "video": "True",
                # "platform": "VISTA",
                # "marionette": "false",
            }
       )
    browser.get(url)
    # Generate out file name:  text=encodedText&relev=encodedRelev1&relev=encodedRelev2.JPG
    query = "text="+ urllib.quote_plus(urlparse.parse_qs(urlparse.urlsplit(url).query)["text"][0])
    relev = ""
    if "relev" in urlparse.parse_qs(urlparse.urlsplit(url).query):
        for r in urlparse.parse_qs(urlparse.urlsplit(url).query)["relev"]:
            relev = relev + "relev=" + urllib.quote_plus(r)  + "&"
    out_filename = query + "&" + relev + ".JPG"
    print out_filename
    # Select element by selector class_selector (if class_selector defined)
    if class_selector:
        elements = []
        elements = browser.find_elements_by_class_name(class_selector) #  find part of the page you want image of
        if len(elements) > 0:
            # Take 1s element because only one distribution element on page
            location = elements[0].location
            size = elements[0].size
            # Make screenshot of whole page
            out_filename_with_path = "out/" + out_filename
            print out_filename_with_path
            browser.save_screenshot(out_filename_with_path)
            browser.quit()
            # Crop Image for only element
            im = Image.open(out_filename_with_path) #  uses PIL library to open image in memory
            left = location['x']
            top = location['y']
            right = location['x'] + size['width']
            bottom = location['y'] + size['height']
            im = im.crop((left, top, right, bottom)) #  defines crop points
            im.save(out_filename_with_path) #  saves new cropped image
            return True
        else:
            # If couldn't find eny element make screenshot of whole page (to see possible errors)
            print "errors/" + out_filename
            browser.save_screenshot("errors/" + out_filename)
            browser.quit()
            return True
    browser.save_screenshot("out/" + out_filename)
    browser.quit()
    return True


if __name__ == '__main__':
    # see testpal for selector: https://testpalm.yandex-team.ru/serp/testcases?filters=%7B"type":"EQ","key":"attributes.55eda6b1e4b098defd6a1dbc","value":"Колдунщик%20дистрибуции"%7D
    ELEMENT_CLASS_NAME_SELECTOR = "z-default-search" # if None than screenshot whole page
    # ELEMENT_CLASS_NAME_SELECTOR = "smart-info" # if None than screenshot whole page

    # url = 'http://yandex.ru/search/touch/?noredirect=1&text=yandex&lr=213'
    f = open("urls.txt")
    url = f.readline()
    while url:
        save_screenshoot(url, ELEMENT_CLASS_NAME_SELECTOR)
        time.sleep(1)
        url = f.readline()
