#!/usr/bin/python
#coding: utf-8
from __future__ import unicode_literals
import argparse
from pprint import pprint
import json

import requests
import urllib

from pygments import highlight
from pygments.lexers import JsonLexer
from pygments.formatters import TerminalFormatter


RTMR_HOST = 'rtmr.search.yandex.net:8080'

def get_data_from_rtmr_response(json_dump):
    j = json.loads(json_dump)
    if "Chunks" in j and j['Chunks'] and "Entries" in j['Chunks'][0] and j['Chunks'][0]['Entries'] and "Value" in j['Chunks'][0]['Entries'][0]:
        return json.loads(j['Chunks'][0]['Entries'][0]['Value'])

def print_json(json_dump):
    j = json.loads(json_dump)
    if "Chunks" in j and j['Chunks'] and "Entries" in j['Chunks'][0] and j['Chunks'][0]['Entries'] and "Value" in j['Chunks'][0]['Entries'][0]:
        j['Chunks'][0]['Entries'][0]['Value'] = json.loads(j['Chunks'][0]['Entries'][0]['Value'])
    json_str = json.dumps(j, indent=4, sort_keys=True)
    print highlight(json_str, JsonLexer(), TerminalFormatter())

def get_joinded_products(id):
    url = "http://%s/api/v1/tables.hr?path=product_profiles/19700101.joined&id=%s&maxrecords=1" % (RTMR_HOST, id)
    print 'JOINED PRODUCTS FOR %s' % id
    print_json(requests.get(url).text)

def get_products(id):
    url = "http://%s/api/v1/tables.hr?path=product_profiles/19700101&id=%s&maxrecords=1" % (RTMR_HOST, id)
    print 'PRODUCTS FOR %s' % id
    print_json(requests.get(url).text)

def get_profile(id):
    url = "http://%s/api/v1/tables.hr?path=product_profiles/19700101&id=%s&maxrecords=1" % (RTMR_HOST, id)
    print 'SOFT_LOG_PROFILE'
    print_json(requests.get(url).text)

def get_mapped(id):
    url = "http://%s/api/v1/tables.hr?path=atom/user_id_mapping&id=%s&maxrecords=1" % (RTMR_HOST, id)
    print 'MAPPED IDs'
    t = requests.get(url).text
    print_json(t)
    ids = get_data_from_rtmr_response(t)
    if ids:
        print "PRODUCTS FOR EACH ID"
        if 'c' in ids:
            for c in ids['c']:
                get_joinded_products(c)
        if 'd' in ids:
            for d in ids['d']:
                get_joinded_products(d)
            for d in ids['d']:
                get_products(d)

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-u', help="yandexuid or uuid")
    args = parser.parse_args()
    get_profile(args.u)
    get_mapped(args.u)
