# -*- coding: utf-8 -*-

import argparse
import io
import json
import time
from pprint import pprint
from collections import OrderedDict

infile = 'infile.json'
outfile = 'out.json'
out = []

with open(infile) as fp:
    data = json.load(fp)

for elem in data:
    elem_out = OrderedDict({
        'lang': elem['lang'],
        'grouping-key': elem['grouping-key'],
        'title': elem['title'],
        'url': elem['url'],
        '__textauthor': '',
        'snippet': '',
        'bandits-weight-expression': elem['bandits-weight-expression'],
        'internal-url': elem['internal-url'] + 'i',
        '__product': elem['__product'],
        'scores': elem['scores'],
        'fml-weight': elem['fml-weight'],
        'filter': elem['filter'],
    })
    elem_aux = elem['aux-data']

    aux_data = OrderedDict({
        '_atom_lang': elem_aux['_atom_lang'],
        '_atom_url': elem_aux['_atom_url'],
        '_description': elem_aux['_description'],
        'close_color': elem_aux['close_color'],
        'context_id': elem_aux['context_id'],
        'data_ts': int(time.time()),
        'height': elem_aux['height'],
        'name': elem_aux['name'],
        'order_id': elem_aux['order_id'],
        'product_name': elem_aux['product_name'],

        'stripe_type': 'promo',
        'position_style': 'fixed',
        'button_target': '_blank',

        '_internal_url': elem_out['internal-url'],
        'age_restriction': elem_aux.get('age_restriction', ''),
        'agreement_text': elem_aux.get('agreement_text', ''),
        'auto_close': elem_aux.get('auto_close', '0'),
        'background_color': elem_aux.get('background_color', ''),
        'background_image': elem_aux.get('background_image', ''),
        'banner_id': elem_out['internal-url'].split('/')[1],
        'button': elem_aux['text2'],
        'button_color': elem_aux.get('text2_color', ''),
        'button_hover_color': elem_aux.get('text2_hover_color', '#fff'),
        'button_font_size': elem_aux.get('text2_font_size', '14'),
        'button_type': 'inline' if 'chrome.google' in elem_aux['text2_url'] else 'landing',
        'button_url': elem_aux['text2_url'],
        'position_type': elem_aux.get('position_type', 'top'),
        'text': elem_out['title'],
        'text_color': elem_aux['text1_color'],
        'text_font_size': elem_aux['text1_font_size'],
        'text_hover_color': elem_aux['text1_hover_color'],
    })

    if aux_data['button_type'] == 'landing':
        aux_data['_link_extensions'] = {
            'button_url': {
                'host': '$host',
                'banner_id': '$banner_id',
                'banerid': 'showid',
                'reqid': 'reqid',
            }
        }

    elem_out['aux-data'] = aux_data
    out.append(elem_out)
    # print aux_data['agreement_text']
    # print aux_data['_description']
out = json.dumps(out, ensure_ascii=False, indent=4, encoding='utf-8', sort_keys=True)

with io.open(outfile, 'w', encoding='utf-8') as fp:
    fp.write(out)
