#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import pdb
import json
import codecs
import argparse
import webbrowser
import datetime
import requests
import urllib
import scipy.stats
sys.path.append('.')
from v4_daily_yt import get_dictionary_from_stat, reverse_dict, HEADERS
from pytils import nda_shorten
from colored import fg, attr
import itertools

STAT_URL = "https://stat.yandex-team.ru/Distribution/Others/AtomBanners/v4_daily?scale=d&_incl_fields=trueinstalls&_incl_fields=shows&browser=1&candidate=3&element={element}&for=&lang=0&os=1&product=0&service=4&testid={testids}&date_min={from_}+00%3A00%3A00&date_max={to_}+23%3A59%3A59&_type=json&_raw_data=1"


def make_list(dct):
    return ([0] * (dct['shows'] - dct['trueinstalls']) +
            [1] * dct['trueinstalls'])


def main():
    parser = argparse.ArgumentParser(
        description='example: python testid_stat_test.py 25366,25367 '
        'distr_stripe 2016-06-07 2016-06-13',
        formatter_class=argparse.RawDescriptionHelpFormatter
    )
    parser.add_argument('testids', help='comma-separated testids: 10000,10001')
    parser.add_argument('element', help='distr element: default_search')
    parser.add_argument('from', help='yyyy-mm-dd date: 2016-08-01')
    parser.add_argument('to', help='yyyy-mm-dd date: 2016-08-02')
    args = parser.parse_args()

    from_ = getattr(args, 'from')
    to_ = getattr(args, 'to')

    element_dict = reverse_dict(
        get_dictionary_from_stat('vcfs::atombanners_element')
    )

    element = element_dict[args.element]

    stat_url = STAT_URL.format(
        from_=from_,
        to_=to_,
        element=element,
        testids=args.testids.replace(',', '&testid=')
    )

    stat_req = requests.get(
        stat_url,
        headers=HEADERS
    )

    stat = json.loads(stat_req.content.decode('utf8'))['values']

    result = {}

    for x in stat:
        shows = x['TOTAL^shows']
        trueinstalls = x['TOTAL^trueinstalls']
        result[x['testid']] = {
            'shows': shows,
            'trueinstalls': trueinstalls,
        }
        print('{} trueinstallrate: {:.6f}'.format(
            x['testid'], trueinstalls / shows
        ))

    for x, y in itertools.combinations(result.keys(), 2):
        p_value = scipy.stats.ttest_ind(
            make_list(result[x]),
            make_list(result[y]),
            equal_var=False
        )[1]
        print('{}/{}: p-value {}{:.4f}{}'.format(
            x,
            y,
            fg('green' if p_value < 0.05 else 'red'),
            p_value,
            attr('reset')
        ))

    print('Look at the data by url: {}'.format(
        nda_shorten(stat_url[:-11])
    ))


if __name__ == "__main__":
    main()
