import json
import requests
from datetime import datetime

from parser_filters import pack, parse
from delete_defaults_filters import delete_defaults, detect_device_target


# infile = 'teaser_service_exp.20160510-1952.txt'
outfile = 'teaser_service_exp.json'
host = 'bannerteaser'
textauthor = 'chikachoff'
fml_weight = 3000
bandits_weight = 0.1
cnt = 999990000

app_map = {
    "taxi": "'#apps,not_match,3'",
    "browser": "'#apps,not_match,5'&'#apps,not_match,6'&'#apps,not_match,7'&'#apps,not_match,8'",
    "music": "'#apps,not_match,21'&'#apps,not_match,21'",
    "radio": "'#apps,not_match,21'&'#apps,not_match,21'",
    "appsearch": "'#apps,not_match,40'&'#apps,not_match,62'",
    "transport": "'#apps,not_match,28'",
    "launcher": "",
    "keyboard": "",
    "market": "'#apps,not_match,16'&'#apps,not_match,17'&'#apps,not_match,18'",
    "autoru": "'#apps,not_match,43'",
    "avia": "",
    "maps": "",
    "snimiteodezdu": "",
}

user_agent_appsearch_map = {
    "iphone": "'#ua,ic_not_match,%android%'&'#ua,ic_not_match,%yaapp_ios%'&'#ua,ic_not_match,%yabrowser%'&'#ua,ic_not_match,%ios 1.%'&'#ua,ic_not_match,%ios 2.%'&'#ua,ic_not_match,%ios 3.%'&'#ua,ic_not_match,%ios 4.%'&'#ua,ic_not_match,%ios 5.%'&'#ua,ic_not_match,%ios 6.%'&'#ua,ic_not_match,%ios 7.%'",
    "android": "'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,%yandexsearch%'&'#ua,ic_not_match,%yabrowser%'&'#ua,ic_not_match,%android 1.%'&'#ua,ic_not_match,%android 2.%'&'#ua,ic_not_match,%android 3.%'"
}

user_agent_browser_map = {
    "iphone": "'#ua,ic_not_match,%android%'&'#ua,ic_not_match,%yabrowser%'&'#ua,ic_not_match,%yaapp_ios%'&'#ua,ic_not_match,%ios 6.%'&'#ua,ic_not_match,%ios 5.%'&'#ua,ic_not_match,%ios 4.%'&'#ua,ic_not_match,%ios 3.%'&'#ua,ic_not_match,%ios 2.%'&'#ua,ic_not_match,%ios 1.%'",
    "android": "'#ua,ic_not_match,%yabrowser%'&'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,%yandexsearch%'&'#ua,ic_not_match,%android 1.%'&'#ua,ic_not_match,%android 2.%'&'#ua,ic_not_match,%android 3.%'&'#ua,ic_not_match,%android 4.0%'"
}

filter_template = "'#lang,eq,{lang}'&'#tld,eq,{tld}'&'#ua,ic_not_match,%windows%'"

collection = []
r = requests.get('http://portal-export.yandex.net/pusher_exports/wrk/teaser_service_exp.json')
data = r.json()['data']

link_extensions = {"_link_extensions": {
                "url": {
                    "atom_bannerid": "$banner_id",
                    "atom_reqid": "reqid",
                    "host": "$host",
                    "yandexuid": "uid"}}}

for aux in data:
    bandits_weight = 0.1
    collection_element = {}
    _timestamp = None
    if aux['till']:
        utc = datetime.strptime(aux['till'], '%Y-%m-%d')
        _timestamp = (utc - datetime(1970, 1, 1)).total_seconds()
        if utc < datetime.today():
            continue

    internal_url = '/'.join([host, str(cnt)])
    snippet = aux['text']
    title = aux['title']
    product = aux['service']
    if product == 'yabrowser':
        product = 'browser'
    url = '/'.join([host, product])
    lang = aux['lang']
    tld = aux['domain']

    if 'appmetrica.yandex' in aux['url'] or 'appmetrika.yandex' in aux['url'] or 'appsflyer' in aux['url']:
        aux.update(link_extensions)
    if 'appsflyer' in aux['url']:
        aux['url']=aux['url']+"&af_siteid=atom"
    aux['banner_id'] = cnt

    # Filters
    collection_element['filter'] = filter_template.format(lang=lang,
                                                          tld=tld)
    if app_map[product]:
        collection_element['filter'] = '&'.join([collection_element['filter'],
                                                 app_map[product]])
    if aux['iphone'] == '1':
        collection_element['filter'] = '&'.join([
                                        "'#ua,match,%iphone%'",
                                        collection_element['filter']])
    if aux['android'] == '1':
        collection_element['filter'] = '&'.join([
                                        "'#ua,match,%android%'",
                                        collection_element['filter']])
    if "geo" in aux and len(aux['geo'])>0:
        collection_element['filter'] = '&'.join([
                                        "'#lr,eq,"+aux['geo']+"'",
                                        collection_element['filter']])
    if product == 'appsearch':
        product = 'search'
        bandits_weight = 1
        if aux['iphone'] == '1':
            collection_element['filter'] = '&'.join([
                                        collection_element['filter'],
                                        user_agent_appsearch_map['iphone']
            ])
        elif aux['android'] == '1':
            collection_element['filter'] = '&'.join([
                                        collection_element['filter'],
                                        user_agent_appsearch_map['android']
            ])
    if product == 'browser':
        bandits_weight = 1
        if aux['iphone'] == '1':
            collection_element['filter'] = '&'.join([
                                        collection_element['filter'],
                                        user_agent_browser_map['iphone']
            ])
        elif aux['android'] == '1':
            collection_element['filter'] = '&'.join([
                                        collection_element['filter'],
                                        user_agent_browser_map['android']
            ])
    if _timestamp:
        collection_element['filter'] = '&'.join([
            collection_element['filter'],
            "'#ts,lt,{}'".format(str(int(_timestamp)))
        ])
    # End filters

    if ' ' in aux['color']:
        colors = [color.rstrip(',') for color in aux['color'].split(' ') if color]
        aux['color'] = ','.join(colors)
    collection_element['__product'] = product
    collection_element['__textauthor'] = textauthor
    collection_element['bandits-weight'] = bandits_weight
    collection_element['bandits-weight-expression'] = "5*install+5*EVENT_AD_INSTALL+real_click"
    collection_element['fml-weight'] = fml_weight
    collection_element['internal-url'] = internal_url
    collection_element['snippet'] = snippet
    collection_element['title'] = title
    collection_element['url'] = url
    collection_element['grouping-key'] = product
    collection_element['aux-data'] = aux


    #optimize filters
    platform_target = detect_device_target(collection_element)
    collection_element['filter'] = pack(delete_defaults(collection_element['filter']))
    if platform_target:
        if collection_element['filter']:
            collection_element['filter'] += "&" + platform_target
        else:
            collection_element['filter'] = platform_target

    collection.append(collection_element)
    cnt += 1

structure = json.dumps(collection,
                       indent=4,
                       encoding='utf-8',
                       ensure_ascii=False).encode('utf-8')

with open(outfile, 'w') as fp:
    fp.write(structure)
