#!/usr/bin/python
# -*- coding: UTF-8 -*-

import yt.wrapper as yt
import nile
import os
from argparse import ArgumentParser
from nile.api.v1 import (
    clusters,
    aggregators as na
)
yt.config['token'] = 'AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
yt.config.set_proxy('hahn.yt.yandex.net')


class Appmetrica:
    def __init__(self, date, filter_strings):
        self.username = 'chikachoff'
        self.date = date
        self.filter_strings = filter_strings
        self.intable = '/'.join([
            '//home/logfeller/logs/metrika-mobile-install-log',
            '1d/{}'.format(self.date)
        ])
        self.out_table = '/'.join([
            '//home/atom/chikachoff/trackers',
            'appmetrica/{}'.format(self.date)
        ])
        self.result = []

    def _filter(self, records):
        for rec in records:
            if rec.get('EventType') != 'EVENT_AD_INSTALL':
                continue
            for filter_string in self.filter_strings:
                if filter_string == rec.get('TrackingID'):
                    yield rec

    def calc(self):
        cluster = clusters.Hahn(
            pool='search-research_{}'.format(self.username),
            token='AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
        )
        job = cluster.job()
        job.table(
            self.intable
        ).map(
            self._filter,
            files=[nile.files.LocalFile(os.path.realpath(__file__))]
        ).groupby(
            'TrackingID'
        ).aggregate(
            count=na.count_distinct('DeviceIDHash')
        ).put(
            self.out_table
        )
        job.run()
        self.result = list(yt.read_table(self.out_table))
        print 'appmetrica log done'
        return {item['TrackingID']: item['count'] for item in self.result}


def main():
    parser = ArgumentParser()
    parser.add_argument('--date', '-d')
    parser.add_argument('--nargs', nargs='+')

    parsed_args = parser.parse_args()
    print parsed_args.nargs
    am = Appmetrica(date=parsed_args.date, filter_strings=parsed_args.nargs)
    am.calc()


if __name__ == '__main__':
    main()
