#!/usr/bin/python
# -*- coding: UTF-8 -*-

import yt.wrapper as yt
import nile
import os
from argparse import ArgumentParser
from nile.api.v1 import (
    clusters,
    aggregators as na
)
yt.config['token'] = 'AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
yt.config.set_proxy('hahn.yt.yandex.net')


class Appsflyer:
    def __init__(self, date, filter_string):
        self.username = 'chikachoff'
        self.date = date
        self.filter_string = filter_string
        self.intable = "//statbox/extdata-apps-flyer-log/{}".format(self.date)
        self.out_table = "//home/atom/chikachoff/trackers/appsflyer/{}".format(
            self.date)
        self.result = []

    def _filter(self, records):
        for rec in records:
            if rec.get('event_type') != 'install':
                continue
            if self.filter_string == rec.get('media_source'):
                yield rec

    def calc(self):
        cluster = clusters.Hahn(
            pool='search-research_{}'.format(self.username),
            token='AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
        )
        job = cluster.job()
        job.table(
            self.intable
        ).map(
            self._filter,
            files=[nile.files.LocalFile(os.path.realpath(__file__))]
        ).groupby(
            'app_id'
        ).aggregate(
            count=na.count()
        ).put(
            self.out_table
        )
        job.run()
        self.result = list(yt.read_table(self.out_table))
        print 'appsflyer log done'
        return {item['app_id']: item['count'] for item in self.result}


def main():
    parser = ArgumentParser()
    parser.add_argument("--date", "-d")
    parser.add_argument("--search", "-s")
    args = parser.parse_args()
    af = Appsflyer(_date=args.date, filter_string=args.search)
    af.calc()


if __name__ == '__main__':
    main()
