#!/usr/bin/python
# -*- coding: UTF-8 -*-

from __future__ import division

import argparse
import json
import requests
from datetime import date, timedelta

from config import products as cfg
import tolokahelper
import appsflyer
import appmetrica

import yt.wrapper as yt
yt.config['token'] = 'AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
yt.config.set_proxy('hahn.yt.yandex.net')

# Config
date_yesterday = (date.today() - timedelta(days=1)).isoformat()
STAT_HOST = 'https://stat.yandex-team.ru/'
STAT_PATH = 'Distribution/Adhoc/trackers'
product_map = {
    'ru.yandex.searchplugin': 'android_appsFlyer_searchApp',
    '457284453463576324': 'android_appMetrica_searchApp',
    'id1050704155': 'ios_appsFlyer_searchApp',
    '817572461318079326': 'ios_appMetrica_searchApp',

    'com.yandex.browser': 'android_appsFlyer_browser',
    '529343269470033102': 'android_appMetrica_browser',
    'id483693909': 'ios_appsFlyer_browser',
    '529343271097346928': 'ios_appMetrica_browser',
}


def update_stat(rows, stat_path):
    requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers={'StatRobotUser': 'robot_aydogank',
                 'StatRobotPassword': 'Aish3ohy9u'},
        data={
            'name': stat_path,
            'scale': 'd',
            'data': json.dumps({'values': rows}),
        },
    )
    stat_url = ''.join([STAT_HOST, stat_path])
    print 'Stat updated\t{}'.format(stat_url)


def calc_metrics(date):
    """
    [
        {
            "fielddate": "2017-02-26",
            "ios_appMetrica_searchApp": 0.8,
            "ios_appMetrica_searchApp_toloka_absolute": 10,
            "ios_appsFlyer_searchApp": 1.0
            "ios_appsFlyer_searchApp_toloka_absolute": 9
            "android_appMetrica_searchApp": 0.8889,
            "android_appMetrica_searchApp_toloka_absolute": 8,
            "android_appsFlyer_searchApp": 0.8889,
            "android_appsFlyer_searchApp_toloka_absolute": 7
        }
    ]
    """
    metric = {'fielddate': date}
    for product, data in fetch_data(date).iteritems():
        prod = product_map[product]
        if 'appmetrika' in data:
            metric[prod] = round(data['appmetrika'] / data['toloka'], 4)
        else:
            metric[prod] = round(data['appsflyer'] / data['toloka'], 4)
        metric['{}_toloka_absolute'.format(prod)] = data['toloka']
    metric = [metric]
    print metric
    update_stat(metric, stat_path=STAT_PATH)


def fetch_data(date):
    data = dict()
    metrika_log_patterns = []
    for product in cfg:
        if 'AppsFlyer' in product:
            flyer_log_pattern = cfg[product]['log_search_pattern']
        if 'AppMetrica' in product:
            metrika_log_patterns.append(cfg[product]['tracking_id'])
    af_result = appsflyer.Appsflyer(date=date, filter_string=flyer_log_pattern).calc()
    am_result = appmetrica.Appmetrica(date=date, filter_strings=metrika_log_patterns).calc()
    toloka_judjements = tolokahelper.TolokaHelper(date=date).fetch_results()
    for tracking_id, count in toloka_judjements.iteritems():
        data[tracking_id] = {'toloka': count}
        # AppMetrika has digit id-s, Appsflyer contains letters too
        if tracking_id.isdigit():
            data[tracking_id]['appmetrika'] = am_result.get(tracking_id, 0)
        else:
            data[tracking_id]['appsflyer'] = af_result.get(tracking_id, 0)
    return data


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('date')
    args = parser.parse_args()

    calc_metrics(args.date)


if __name__ == '__main__':
    main()
