##!/usr/bin/env python
# -*- coding: UTF-8 -*-
'''
https://st.yandex-team.ru/MOPER-135
'''

import requests
import requests.packages.urllib3
import json
# from pprint import pprint
# import os
# from time import sleep

requests.packages.urllib3.disable_warnings()


class _MetrikaRequest:
    def __init__(self, request, address, access_token,
                 data=None, params=None, headers=None):
        data = self._encode_data(data)
        params = self._encode_dict(params)
        headers = self._encode_dict(headers)
        headers = self._prepare_headers(headers, access_token)
        self.request = request(url=address, data=data,
                               headers=headers, params=params, verify=False)
        self.status_code = self.request.status_code
        self.text = self.request.text
        try:
            self.json = self.request.json()
        except ValueError:
            self.json = None
        if isinstance(self.json, dict) and self.json.get('success') is False:
            self.error = self.json.get('msg')
            self.success = False
        else:
            self.error = None
            self.success = self.status_code >= 200 and self.status_code < 300

    def __repr__(self):
        return "<_MetrikaRequest code:{0}>".format(self.status_code)

    def __str__(self):
        if self.json is not None:
            return json.dumps(self.json)
        elif self.text:
            return self.text
        else:
            return "code:{0}".format(self.status_code)

    def _encode_data(self, data):
        if isinstance(data, dict) or isinstance(data, list):
            data = json.dumps(data)
        if isinstance(data, unicode):
            data = data.encode('utf-8')
        if isinstance(data, str):
            data = bytes(data)
        return data

    def _encode_dict(self, headers):
        if isinstance(headers, dict):
            headers = dict((
                k.encode('ascii') if isinstance(k, unicode) else k,
                v.encode('ascii') if isinstance(v, unicode) else v)
                for k, v in headers.iteritems()
            )
        return headers

    def _prepare_headers(self, headers, access_token):
        auth = {"Authorization": "OAuth {0}".format(access_token),
                "Content-Type": "application/json;charset=UTF-8"}
        if not headers:
            return auth
        else:
            headers.update(auth)
            return headers


class _MetrikaRequestException(Exception):
    def __init__(self, request):
        message = """Metrika request has failed.
        Code: {0}.
        URL: {1}.
        Error: {2}.
        json: {3}.""".format(
            request.status_code,
            request.request.url,
            request.error,
            json.dumps(request.json, sort_keys=True, indent=2))
        super(_MetrikaRequestException, self).__init__(message)
        self.request = request


class MetrikaAPI:
    def __init__(self, api_url, access_token, strict=False):
        self.api_url = api_url
        self.access_token = access_token
        self.strict_mode = strict

    def get(self, address, data='', params=None):
        return self._request(requests.get, address, data, params)

    def post(self, address, data='', params=None):
        return self._request(requests.post, address, data, params)

    def delete(self, address, data='', params=None):
        return self._request(requests.delete, address, data, params)

    def put(self, address, data='', params=None):
        return self._request(requests.put, address, data, params)

    def patch(self, address, data='', params=None):
        return self._request(requests.patch, address, data, params)

    def _request(self, request, address, data='', params=None):
        request = _MetrikaRequest(
            request, self.api_url + address, self.access_token, data, params
        )
        if self.strict_mode and not request.success:
            raise _MetrikaRequestException(request)
        return request


class Metrika:
    def __init__(self, api=None, token=None, strict=True):
        api = api or 'https://api.appmetrica.yandex.ru'
        token = token or 'AQAAAAAME5e9AAQtFSHcw5TMCUTxkWqc_UeNwgQ'
        self.api = MetrikaAPI(api, token, strict=strict)
        self.api_path = '/management/v1/application/{app_id}/testdevices'

    # Tests
    '''app_id яндексовых приложений:
    10321   ПП Android
    42989   ПП IOS
    106400  Бро Android
    19531   Бро IOS
    '''
    def test_add_device_ios(self, app_id=42989):
        response = self.add_device(
            app_id=app_id,
            device_id='F637EDD9-6B92-4859-ABB4-925EFE2EFA5E',  # idfa
            name='test_device_ios',
            type='ios_ifa',
            purpose='reattribution')
        assert response.get('device')
        print 'test_add_device_ios...OK'
        # Cleanup
        internal_id = response.get('device').get('id')
        self.delete_device(app_id=app_id, internal_id=internal_id)
        print 'test_delete_device_ios...OK'

    def test_add_device_android(self, app_id=10321):
        response = self.add_device(
            app_id=app_id,
            device_id='4aefbe36-363a-4b32-944e-8fb26def8cf8',  # gaid
            name='test_device_android',
            type='google_aid',
            purpose='reattribution')
        assert response.get('device')
        print 'test_add_device_android...OK'
        # Cleanup
        internal_id = response.get('device').get('id')
        self.delete_device(app_id=app_id, internal_id=internal_id)
        print 'test_delete_device_android...OK'

    def test_delete_device(self):
        response = self.delete_device(app_id=10321, internal_id='7579')
        assert response.status_code == 200
        print 'test_delete_device...OK'

    # Functionality
    def list_devices(self, app_id):
        response = self.api.get(self.api_path.format(app_id=app_id)).json
        return response.get('devices')

    def add_device(self, app_id, **kwargs):
        data = {'device': kwargs}
        return self.api.post(self.api_path.format(app_id=app_id), data).json

    def delete_device(self, app_id, internal_id):
        url_path = self.api_path.format(app_id=app_id)
        return self.api.delete('{}/{}'.format(url_path, internal_id))
