#!/usr/bin/python
# -*- coding: UTF-8 -*-

from datetime import date, timedelta
from time import sleep
import toloka


class TolokaHelper:
    """
    For Toloka API documentation reference
    https://tech.yandex.ru/toloka/api/doc/concepts/about-docpage/
    """
    token = 'AQAAAAAS64C8AACtpfjTQ5fpiU-Uq-P7mdazEhE'
    api = 'https://toloka.yandex.ru/api/v1'

    def __init__(self, date, api=api, token=token,
                 project_descriptor=u'Качество трекера'):
        self.accepted_status = 'ACCEPTED'
        self.pools_limit = 300
        self.assignments_limit = 400
        self.date = date
        self.project_descriptor = project_descriptor
        self.tlk = toloka.Toloka(api=api, token=token)

    def get_all_pools(self):
        return (
            pool for pool in
            self.tlk.pools(
                limit=self.pools_limit,
                last_started_gte='{}T{}'.format(self.date, '00:00'),
                last_started_lte='{}T{}'.format(self.date, '23:59'),
                status='CLOSED'
            )['items']
        )

    def get_projects(self):
        return (
            project['id']
            for project in self.tlk.projects(limit=300)['items']
            if self.project_descriptor in project['public_name']
        )

    def get_assignments(self, pool_id):
        return self.tlk.assignments(pool_id, self.assignments_limit)['items']

    def get_pools_daily(self):
        pools = dict()
        all_pools = tuple(self.get_all_pools())
        tracker_projects = tuple(self.get_projects())
        for pool in all_pools:
            if pool.get('project_id') not in tracker_projects:
                continue
            created = pool.get('created')
            if self.date in created:
                pools[pool.get('id')] = {
                    'trk': pool.get('private_comment'),
                    'count': 0
                }
        return pools

    def fetch_results(self):
        pools = self.get_pools_daily()
        for pool_id in pools:
            for assignment in self.get_assignments(pool_id=pool_id):
                if assignment.get('status') != self.accepted_status:
                    continue
                pools[pool_id]['count'] += 1
        return {data['trk']: data['count'] for _, data in pools.iteritems()}

    # New assignments
    def clone_pool(self, original_pool_id):
        created_pool = None
        original_pool = self.tlk.pool(original_pool_id)
        tomorrow_at_0am = '{}{}'.format(
            (date.today() + timedelta(days=1)).isoformat(), 'T00:00:00'
        )
        new_pool = {
            k: v for k, v in original_pool.iteritems()
            if k not in (
                'created',
                'id',
                'last_started',
                'last_stopped',
                'status'
            )
        }
        new_pool['private_name'] = '{}'.format(date.today())
        new_pool['will_expire'] = tomorrow_at_0am

        created_pool = self.tlk.create_pool(**new_pool)
        print 'Pool {} created'.format(created_pool['id'])
        return created_pool['id']

    def fill_data(self, pool_id, tasks_count):
        for _id in xrange(tasks_count):
            task_suite = {
                'pool_id': pool_id,
                'tasks': [{'input_values': {'id': str(_id)}}],
                'overlap': 1,
            }
            while True:
                try:
                    self.tlk.upload_tasks(**task_suite)
                except:
                    sleep(1)
                break
        print 'Pool ID: {}\tFilled with {} tasks'.format(
            pool_id, tasks_count
        )

    def give_assignments(self, original_pool_id, tasks_count):
        new_pool_id = self.clone_pool(original_pool_id)
        self.fill_data(pool_id=new_pool_id, tasks_count=tasks_count)
        self.tlk.open_pool(new_pool_id)
        print 'Pool {} opened\n'.format(new_pool_id)
