#!/usr/bin/env python
#! -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import requests
import json
from tqdm import tqdm

skeleton = 'http://suggest-internal.yandex.net/suggest-ub?yandexuid='


def get_active1(yu):
    req = requests.get(skeleton + yu)
    result = json.loads(req.text)
    return result.get('active1') or 0


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('filename')
    args = parser.parse_args()
    yandexuids = {}
    with codecs.open(args.filename, 'r', 'utf8') as f:
        for line in tqdm(f):
            yu = line.rstrip()
            if yu not in yandexuids:
                yandexuids[yu] = get_active1(yu)
    with codecs.open(args.filename + '.active.json', 'w', 'utf8') as f:
        f.write(json.dumps(yandexuids, indent=4, ensure_ascii=False))

if __name__ == "__main__":
    main()
