# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import os
import argparse
import datetime

from yamon.pushers.buffered_razladki_pusher import BufferedRazladkiPusher
from yamon.providers.rtmr_table_stats_provider import RtmrTableStatsProvider
from yamon.configs.template_config import TemplateConfig
from yamon.monitorers.rtmr_table_stats_monitorer import RtmrTableStatsMonitorer
from yamon.managers.timeout_monitoring_manager import TimeoutMonitoringManager
from yamon.utils.monitorings import get_monitoring_name, get_yamon_path


def main(config):
    monitorers = [
        RtmrTableStatsMonitorer(
            pusher=BufferedRazladkiPusher(config['pusher']['projects'], config['do_push']),
            provider=RtmrTableStatsProvider(),
            config=config['monitorer']
        )
    ]
    for monitorer in monitorers:
        monitorer.run()


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--no_push', action='store_true', help='Do not send results anywhere')
    parser.add_argument(
        '--log_mode', type=str, default='default',
        choices=['default', 'document', 'console', 'email', 'verbose', 'debug'],
        help=(
              'default - log to file and send critical emails, '
              'document - log to file, '
              'debug - detailed log to console, '
              'console - log to console, '
              'email - send critical emails, '
              'verbose - detailed log to file and console and send critical emails'
        )
    )
    parser.add_argument('--timeout', type=float, default=None, help='Maximum time allowed for monitoring execution')

    args = parser.parse_args()

    path = os.path.abspath(__file__)
    name = get_monitoring_name(path)
    yamon_path = get_yamon_path(path)
    config = TemplateConfig(
        source='{}/watchers/{}/config.json'.format(yamon_path, name),
        templates={
            '$YAMON_PATH': yamon_path,
            '$NAME': name,
            '$LOG_TYPE': name,
            '$LOG_NAME': '{}.log'.format(datetime.datetime.now().strftime('%Y-%m-%d_%H-%M-%S'))
        }
    )

    config['manager']['log_mode'] = args.log_mode
    config['manager']['timeout'] = args.timeout
    config['monitoring']['do_push'] = not args.no_push

    manager = TimeoutMonitoringManager(name=name, config=config['manager'])
    manager.run(main, config['monitoring'])
