# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import numpy
import datetime
import logging


class ClickhouseAtomAggregator(object):
    def __init__(self):
        super(ClickhouseAtomAggregator, self).__init__()
        self.logger = logging.getLogger(__name__)

    def aggregate(self, data):
        self.logger.info('Aggregating data')
        context = ['host', 'product', 'event', 'region', 'referer', 'client', 'subclient', 'browser', 'os']
        contexts_lists = data.groupby(context, as_index=False)\
            .aggregate({
                'list': lambda lists: ','.join(sorted(lists.unique()))
            })
        aggregated = data.groupby(context + ['bannerid'], as_index=False)\
            .aggregate({
                'count': numpy.max,
                'banner_update_ts': numpy.max,
                'update_ts': numpy.max,
            })\
            .groupby(context, as_index=False)\
            .aggregate({
                'count': numpy.sum,
                'banner_update_ts': numpy.max,
                'update_ts': numpy.max,
            })\
            .merge(
                contexts_lists,
                how='left',
                on=context,
                sort=False
            )
        aggregated['lists'] = aggregated['list'].apply(
            lambda lists: lists.split(',')
        )
        aggregated['event_date'] = aggregated['update_ts'].apply(
            lambda ts: datetime.date.today().strftime('%Y-%m-%d')
        )
        aggregated['update_ts'] = aggregated['update_ts'].apply(
            lambda ts: datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        )
        return aggregated
