# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import copy

from ..utils.json import load_json


class Config(dict):
    def __init__(self, source):
        super(Config, self).__init__()
        if isinstance(source, dict):
            settings = copy.deepcopy(source)
        elif isinstance(source, basestring):
            settings = load_json(source)
        else:
            raise ValueError('Failed to build config from source: {}'.format(source))
        self.update(settings)
