# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import os

from .config import Config
from ..utils.json import decode_json, encode_json


class TemplateConfig(Config):
    def __init__(self, source, templates=None):
        super(TemplateConfig, self).__init__(source)
        settings = self.__apply_templates(encode_json(self), templates)
        self.clear()
        self.update(decode_json(settings))

    def __apply_templates(self, settings, templates):
        if templates is not None:
            for template, substitute in templates.items():
                settings = settings.replace(template, substitute)
        return settings
