# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import logging

from .json_holder import JsonHolder


class CachingJsonHolder(JsonHolder):
    def __init__(self, config):
        super(CachingJsonHolder, self).__init__(config)
        self.logger = logging.getLogger(__name__)
        self.__cache = {}

    def load(self, path):
        if path not in self.__cache:
            self.__cache[path] = super(CachingJsonHolder, self).load(path)
        return self.__cache[path]

    def clear_cache(self):
        self.__cache.clear()
